/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceAuthentication;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.services.RequestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class EPersonRestAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(EPersonRestAuthenticationProvider.class);
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RequestService requestService;
    @Autowired
    private HttpServletRequest request;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Context context = ContextUtil.obtainContext((ServletRequest)this.request);
        if (context != null && context.getCurrentUser() != null) {
            return this.authenticateRefreshTokenRequest(context);
        }
        return this.authenticateNewLogin(authentication);
    }

    private Authentication authenticateRefreshTokenRequest(Context context) {
        this.authenticationService.updateLastActiveDate(context);
        return this.createAuthentication(null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Authentication authenticateNewLogin(Authentication authentication) {
        Authentication output;
        block11: {
            Context newContext = null;
            output = null;
            if (authentication != null) {
                try {
                    newContext = new Context();
                    String name = authentication.getName();
                    String password = Objects.toString(authentication.getCredentials(), null);
                    int implicitStatus = this.authenticationService.authenticateImplicit(newContext, null, null, null, this.request);
                    if (implicitStatus == 1) {
                        log.info(LogManager.getHeader((Context)newContext, (String)"login", (String)"type=implicit"));
                        output = this.createAuthentication(password, newContext);
                        break block11;
                    }
                    int authenticateResult = this.authenticationService.authenticate(newContext, name, password, null, this.request);
                    if (1 == authenticateResult) {
                        log.info(LogManager.getHeader((Context)newContext, (String)"login", (String)"type=explicit"));
                        output = this.createAuthentication(password, newContext);
                        break block11;
                    }
                    log.info(LogManager.getHeader((Context)newContext, (String)"failed_login", (String)("email=" + name + ", result=" + authenticateResult)));
                    throw new BadCredentialsException("Login failed");
                }
                finally {
                    if (newContext != null && newContext.isValid()) {
                        try {
                            newContext.complete();
                        }
                        catch (SQLException e) {
                            log.error(e.getMessage() + " occurred while trying to close", (Throwable)e);
                        }
                    }
                }
            }
        }
        return output;
    }

    private Authentication createAuthentication(String password, Context context) {
        EPerson ePerson = context.getCurrentUser();
        if (ePerson != null && StringUtils.isNotBlank((CharSequence)ePerson.getEmail())) {
            this.requestService.setCurrentUserId(ePerson.getID());
            return new DSpaceAuthentication(ePerson, this.getGrantedAuthorities(context, ePerson));
        }
        log.info(LogManager.getHeader((Context)context, (String)"failed_login", (String)"No eperson with an non-blank e-mail address found"));
        throw new BadCredentialsException("Login failed");
    }

    public List<GrantedAuthority> getGrantedAuthorities(Context context, EPerson eperson) {
        LinkedList<GrantedAuthority> authorities = new LinkedList<GrantedAuthority>();
        if (eperson != null) {
            boolean isAdmin = false;
            try {
                isAdmin = this.authorizeService.isAdmin(context, eperson);
            }
            catch (SQLException e) {
                log.error("SQL error while checking for admin rights", (Throwable)e);
            }
            if (isAdmin) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ADMIN"));
            }
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority("AUTHENTICATED"));
        }
        return authorities;
    }

    public boolean supports(Class<?> authentication) {
        return DSpaceAuthentication.class.isAssignableFrom(authentication);
    }
}

