/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.scripts.handler.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.ProcessStatus;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.Process;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ProcessService;

public class RestDSpaceRunnableHandler
implements DSpaceRunnableHandler {
    private static final Logger log = LogManager.getLogger(RestDSpaceRunnableHandler.class);
    private ProcessService processService = ScriptServiceFactory.getInstance().getProcessService();
    private Integer processId;
    private String scriptName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestDSpaceRunnableHandler(EPerson ePerson, String scriptName, List<DSpaceCommandLineParameter> parameters) {
        Context context = new Context();
        try {
            Process process = this.processService.create(context, ePerson, scriptName, parameters);
            this.processId = process.getID();
            this.scriptName = process.getName();
            context.complete();
        }
        catch (SQLException e) {
            log.error("RestDSpaceRunnableHandler with ePerson: " + ePerson.getEmail() + " for Script with name: " + scriptName + " and parameters: " + parameters + " could nto be created", (Throwable)e);
        }
        finally {
            if (context.isValid()) {
                context.abort();
            }
        }
    }

    public void start() {
        Context context = new Context();
        try {
            Process process = this.processService.find(context, this.processId.intValue());
            this.processService.start(context, process);
            context.complete();
            this.logInfo("The script has started");
        }
        catch (SQLException e) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " could not be started", (Throwable)e);
        }
        finally {
            if (context.isValid()) {
                context.abort();
            }
        }
    }

    public void handleCompletion() {
        Context context = new Context();
        try {
            Process process = this.processService.find(context, this.processId.intValue());
            this.processService.complete(context, process);
            context.complete();
            this.logInfo("The script has completed");
        }
        catch (SQLException e) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " could not be completed", (Throwable)e);
        }
        finally {
            if (context.isValid()) {
                context.abort();
            }
        }
    }

    public void handleException(Exception e) {
        this.handleException(null, e);
    }

    public void handleException(String message) {
        this.handleException(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(String message, Exception e) {
        if (message != null) {
            this.logError(message);
        }
        if (e != null) {
            this.logError(ExceptionUtils.getStackTrace((Throwable)e));
        }
        Context context = new Context();
        try {
            Process process = this.processService.find(context, this.processId.intValue());
            this.processService.fail(context, process);
            context.complete();
        }
        catch (SQLException sqlException) {
            log.error("SQL exception while handling another exception", (Throwable)e);
        }
        finally {
            if (context.isValid()) {
                context.abort();
            }
        }
    }

    public void logDebug(String message) {
        String logMessage = this.getLogMessage(message);
        log.debug(logMessage);
    }

    private String getLogMessage(String message) {
        return String.format("Process id: %d, script name: %s, message: %s", this.processId, this.scriptName, message);
    }

    public void logInfo(String message) {
        String logMessage = this.getLogMessage(message);
        log.info(logMessage);
    }

    public void logWarning(String message) {
        String logMessage = this.getLogMessage(message);
        log.warn(logMessage);
    }

    public void logError(String message) {
        String logMessage = this.getLogMessage(message);
        log.error(logMessage);
    }

    public void printHelp(Options options, String name) {
        if (options != null) {
            HelpFormatter formatter = new HelpFormatter();
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            formatter.printUsage(pw, 1000, name, options);
            pw.flush();
            String helpString = out.toString();
            this.logInfo(helpString);
        }
    }

    public Process getProcess() {
        Context context = new Context();
        try {
            Process process = this.processService.find(context, this.processId.intValue());
            return process;
        }
        catch (SQLException e) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " could not be found", (Throwable)e);
        }
        finally {
            if (context.isValid()) {
                context.abort();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(DSpaceRunnable script) {
        Context context = new Context();
        try {
            Process process = this.processService.find(context, this.processId.intValue());
            process.setProcessStatus(ProcessStatus.SCHEDULED);
            this.processService.update(context, process);
            context.complete();
        }
        catch (SQLException e) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " ran into an SQLException", (Throwable)e);
        }
        finally {
            if (context.isValid()) {
                context.abort();
            }
        }
        script.run();
    }
}

