/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.DSpaceObjectMetadataPatchUtils;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DSpaceObjectMetadataRemoveOperation<R extends DSpaceObject>
extends PatchOperation<R> {
    @Autowired
    DSpaceObjectMetadataPatchUtils metadataPatchUtils;

    public R perform(Context context, R resource, Operation operation) throws SQLException {
        DSpaceObjectService dsoService = ContentServiceFactory.getInstance().getDSpaceObjectService(resource);
        String indexInPath = this.metadataPatchUtils.getIndexFromPath(operation.getPath());
        MetadataField metadataField = this.metadataPatchUtils.getMetadataField(context, operation);
        this.remove(context, resource, dsoService, metadataField, indexInPath);
        return resource;
    }

    private void remove(Context context, DSpaceObject dso, DSpaceObjectService dsoService, MetadataField metadataField, String index) {
        block6: {
            this.metadataPatchUtils.checkMetadataFieldNotNull(metadataField);
            try {
                if (index == null) {
                    dsoService.clearMetadata(context, dso, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier(), "*");
                    break block6;
                }
                List metadataValues = dsoService.getMetadata(dso, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier(), "*");
                int indexInt = Integer.parseInt(index);
                if (indexInt >= 0 && metadataValues.size() > indexInt && metadataValues.get(indexInt) != null) {
                    dsoService.removeMetadataValues(context, dso, Arrays.asList((MetadataValue)metadataValues.get(indexInt)));
                    break block6;
                }
                throw new UnprocessableEntityException("UnprocessableEntityException - There is no metadata of this type at that index");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("This index (" + index + ") is not valid number.", e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new UnprocessableEntityException("There is no metadata of this type at that index");
            }
            catch (SQLException e) {
                throw new DSpaceBadRequestException("SQLException in DspaceObjectMetadataRemoveOperation.remove trying to remove metadata from dso.", (Exception)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean supports(Object objectToMatch, Operation operation) {
        if (!operation.getPath().startsWith("/metadata")) {
            if (!operation.getPath().equals("/metadata")) return false;
        }
        if (!operation.getOp().trim().equalsIgnoreCase("remove")) return false;
        if (!(objectToMatch instanceof DSpaceObject)) return false;
        return true;
    }
}

