/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.JsonValueEvaluator;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class DSpaceObjectMetadataPatchUtils {
    private ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private MetadataFieldService metadataFieldService;
    protected static final String OPERATION_METADATA_PATH = "/metadata";

    private DSpaceObjectMetadataPatchUtils() {
    }

    protected MetadataValueRest extractMetadataValueFromOperation(Operation operation) {
        MetadataValueRest metadataValue = null;
        try {
            if (operation.getValue() != null) {
                if (operation.getValue() instanceof JsonValueEvaluator) {
                    JsonNode valueNode = ((JsonValueEvaluator)operation.getValue()).getValueNode();
                    metadataValue = valueNode.isArray() ? (MetadataValueRest)this.objectMapper.treeToValue((TreeNode)valueNode.get(0), MetadataValueRest.class) : (MetadataValueRest)this.objectMapper.treeToValue((TreeNode)valueNode, MetadataValueRest.class);
                }
                if (operation.getValue() instanceof String) {
                    String valueString = (String)operation.getValue();
                    metadataValue = new MetadataValueRest();
                    metadataValue.setValue(valueString);
                }
            }
        }
        catch (IOException e) {
            throw new DSpaceBadRequestException("IOException in DspaceObjectMetadataOperation.extractMetadataValueFromOperation trying to map json from operation.value to MetadataValue class.", (Exception)e);
        }
        if (metadataValue == null) {
            throw new DSpaceBadRequestException("Could not extract MetadataValue Object from Operation");
        }
        return metadataValue;
    }

    protected String extractMdFieldStringFromOperation(Operation operation) {
        String mdElement = StringUtils.substringBetween((String)operation.getPath(), (String)"/metadata/", (String)"/");
        if (mdElement == null && (mdElement = StringUtils.substringAfter((String)operation.getPath(), (String)"/metadata/")) == null) {
            throw new DSpaceBadRequestException("No metadata field string found in path: " + operation.getPath());
        }
        return mdElement;
    }

    protected MetadataValueRest convertMdValueToRest(MetadataValue md) {
        MetadataValueRest dto = new MetadataValueRest();
        dto.setAuthority(md.getAuthority());
        dto.setConfidence(md.getConfidence());
        dto.setLanguage(md.getLanguage());
        dto.setPlace(md.getPlace());
        dto.setValue(md.getValue());
        return dto;
    }

    protected String extractPropertyOfMdFromPath(String[] partsOfPath) {
        return partsOfPath.length > 4 ? partsOfPath[4] : null;
    }

    protected String extractNewValueOfMd(Operation operation) {
        if (operation.getValue() instanceof String) {
            return (String)operation.getValue();
        }
        return null;
    }

    protected MetadataField getMetadataField(Context context, Operation operation) throws SQLException {
        String mdElement = this.extractMdFieldStringFromOperation(operation);
        return this.metadataFieldService.findByString(context, mdElement, '.');
    }

    protected String getIndexFromPath(String path) {
        String[] partsOfPath = path.split("/");
        return partsOfPath.length > 3 ? partsOfPath[3] : null;
    }

    protected void checkMetadataFieldNotNull(MetadataField metadataField) {
        if (metadataField == null) {
            throw new DSpaceBadRequestException("There was no metadataField found in path of operation");
        }
    }
}

