/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.AccessConditionOptionRest;
import org.dspace.app.rest.model.SubmissionUploadRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.SubmissionFormRestRepository;
import org.dspace.app.rest.utils.DateMathParser;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.submit.model.AccessConditionOption;
import org.dspace.submit.model.UploadConfiguration;
import org.dspace.submit.model.UploadConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissionupload")
public class SubmissionUploadRestRepository
extends DSpaceRestRepository<SubmissionUploadRest, String> {
    private static final Logger log = LogManager.getLogger(SubmissionUploadRestRepository.class);
    private SubmissionConfigReader submissionConfigReader;
    @Autowired
    private SubmissionFormRestRepository submissionFormRestRepository;
    @Autowired
    private UploadConfigurationService uploadConfigurationService;
    @Autowired
    GroupService groupService;
    DateMathParser dateMathParser = new DateMathParser();

    public SubmissionUploadRestRepository() throws SubmissionConfigReaderException {
        this.submissionConfigReader = new SubmissionConfigReader();
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public SubmissionUploadRest findOne(Context context, String submitName) {
        UploadConfiguration config = (UploadConfiguration)this.uploadConfigurationService.getMap().get(submitName);
        try {
            return this.convert(context, config, this.utils.obtainProjection());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<SubmissionUploadRest> findAll(Context context, Pageable pageable) {
        List subConfs = new ArrayList();
        subConfs = this.submissionConfigReader.getAllSubmissionConfigs(Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
        Projection projection = this.utils.obtainProjection();
        ArrayList<SubmissionUploadRest> results = new ArrayList<SubmissionUploadRest>();
        for (SubmissionConfig config : subConfs) {
            for (int i = 0; i < config.getNumberOfSteps(); ++i) {
                UploadConfiguration uploadConfig;
                SubmissionStepConfig step = config.getStep(i);
                if (!"upload".equals(step.getType()) || (uploadConfig = (UploadConfiguration)this.uploadConfigurationService.getMap().get(step.getId())) == null) continue;
                try {
                    results.add(this.convert(context, uploadConfig, projection));
                    continue;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return new PageImpl(results, pageable, (long)results.size());
    }

    public Class<SubmissionUploadRest> getDomainClass() {
        return SubmissionUploadRest.class;
    }

    private SubmissionUploadRest convert(Context context, UploadConfiguration config, Projection projection) throws Exception {
        SubmissionUploadRest result = new SubmissionUploadRest();
        result.setProjection(projection);
        for (AccessConditionOption option : config.getOptions()) {
            Group group;
            AccessConditionOptionRest optionRest = new AccessConditionOptionRest();
            if (option.getGroupName() != null && (group = this.groupService.findByName(context, option.getGroupName())) != null) {
                optionRest.setGroupUUID(group.getID());
            }
            if (option.getSelectGroupName() != null && (group = this.groupService.findByName(context, option.getSelectGroupName())) != null) {
                optionRest.setSelectGroupUUID(group.getID());
            }
            optionRest.setHasStartDate(option.getHasStartDate());
            optionRest.setHasEndDate(option.getHasEndDate());
            if (StringUtils.isNotBlank((CharSequence)option.getStartDateLimit())) {
                optionRest.setMaxStartDate(this.dateMathParser.parseMath(option.getStartDateLimit()));
            }
            if (StringUtils.isNotBlank((CharSequence)option.getEndDateLimit())) {
                optionRest.setMaxEndDate(this.dateMathParser.parseMath(option.getEndDateLimit()));
            }
            optionRest.setName(option.getName());
            result.getAccessConditionOptions().add(optionRest);
        }
        result.setMetadata(this.submissionFormRestRepository.findOne(context, config.getMetadata()));
        result.setMaxSize(config.getMaxSize());
        result.setRequired(config.isRequired().booleanValue());
        result.setName(config.getName());
        return result;
    }
}

