/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.DSpaceRunnableParameterConverter;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.ParameterValueRest;
import org.dspace.app.rest.model.ProcessRest;
import org.dspace.app.rest.model.ScriptRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.scripts.handler.impl.RestDSpaceRunnableHandler;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ScriptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;

@Component(value="system.script")
public class ScriptRestRepository
extends DSpaceRestRepository<ScriptRest, String> {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private DSpaceRunnableParameterConverter dSpaceRunnableParameterConverter;

    public ScriptRest findOne(Context context, String name) {
        DSpaceRunnable dSpaceRunnable = this.scriptService.getScriptForName(name);
        if (dSpaceRunnable != null) {
            if (dSpaceRunnable.isAllowedToExecute(context)) {
                return (ScriptRest)this.converter.toRest((Object)dSpaceRunnable, this.utils.obtainProjection());
            }
            throw new AccessDeniedException("The current user was not authorized to access this script");
        }
        throw new DSpaceBadRequestException("The script with name: " + name + " could not be found");
    }

    public Page<ScriptRest> findAll(Context context, Pageable pageable) {
        List dSpaceRunnables = this.scriptService.getDSpaceRunnables(context);
        return this.converter.toRestPage(this.utils.getPage(dSpaceRunnables, pageable), this.utils.obtainProjection());
    }

    public Class<ScriptRest> getDomainClass() {
        return ScriptRest.class;
    }

    public ProcessRest startProcess(String scriptName) throws SQLException, IOException, AuthorizeException {
        Context context = this.obtainContext();
        String properties = this.requestService.getCurrentRequest().getServletRequest().getParameter("properties");
        List dSpaceCommandLineParameters = this.processPropertiesToDSpaceCommandLineParameters(properties);
        DSpaceRunnable scriptToExecute = this.scriptService.getScriptForName(scriptName);
        if (scriptToExecute == null) {
            throw new DSpaceBadRequestException("The script for name: " + scriptName + " wasn't found");
        }
        if (!scriptToExecute.isAllowedToExecute(context)) {
            throw new AuthorizeException("Current user is not eligible to execute script with name: " + scriptName);
        }
        RestDSpaceRunnableHandler restDSpaceRunnableHandler = new RestDSpaceRunnableHandler(context.getCurrentUser(), scriptName, dSpaceCommandLineParameters);
        List args = this.constructArgs(dSpaceCommandLineParameters);
        try {
            this.runDSpaceScript(scriptToExecute, restDSpaceRunnableHandler, args);
            context.complete();
            return (ProcessRest)this.converter.toRest((Object)restDSpaceRunnableHandler.getProcess(), this.utils.obtainProjection());
        }
        catch (SQLException e) {
            log.error("Failed to create a process with user: " + context.getCurrentUser() + " scriptname: " + scriptName + " and parameters " + DSpaceCommandLineParameter.concatenate((List)dSpaceCommandLineParameters), (Throwable)e);
            return null;
        }
    }

    private List<DSpaceCommandLineParameter> processPropertiesToDSpaceCommandLineParameters(String propertiesJson) throws IOException {
        List<Object> parameterValueRestList = new LinkedList();
        ObjectMapper objectMapper = new ObjectMapper();
        if (StringUtils.isNotBlank((CharSequence)propertiesJson)) {
            parameterValueRestList = Arrays.asList((ParameterValueRest[])objectMapper.readValue(propertiesJson, ParameterValueRest[].class));
        }
        LinkedList<DSpaceCommandLineParameter> dSpaceCommandLineParameters = new LinkedList<DSpaceCommandLineParameter>();
        dSpaceCommandLineParameters.addAll(parameterValueRestList.stream().map(x -> this.dSpaceRunnableParameterConverter.toModel(x)).collect(Collectors.toList()));
        return dSpaceCommandLineParameters;
    }

    private List<String> constructArgs(List<DSpaceCommandLineParameter> dSpaceCommandLineParameters) {
        ArrayList<String> args = new ArrayList<String>();
        for (DSpaceCommandLineParameter parameter : dSpaceCommandLineParameters) {
            args.add(parameter.getName());
            if (parameter.getValue() == null) continue;
            args.add(parameter.getValue());
        }
        return args;
    }

    private void runDSpaceScript(DSpaceRunnable scriptToExecute, RestDSpaceRunnableHandler restDSpaceRunnableHandler, List<String> args) {
        try {
            scriptToExecute.initialize(args.toArray(new String[0]), (DSpaceRunnableHandler)restDSpaceRunnableHandler);
            restDSpaceRunnableHandler.schedule(scriptToExecute);
        }
        catch (ParseException e) {
            scriptToExecute.printHelp();
            restDSpaceRunnableHandler.handleException("Failed to parse the arguments given to the script with name: " + scriptToExecute.getName() + " and args: " + args, (Exception)((Object)e));
        }
    }
}

