/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.MissingParameterException;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.ResourcePolicyRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.patch.ResourcePatch;
import org.dspace.app.rest.utils.DSpaceObjectUtils;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="authz.resourcepolicy")
public class ResourcePolicyRestRepository
extends DSpaceRestRepository<ResourcePolicyRest, Integer> {
    @Autowired
    ResourcePolicyService resourcePolicyService;
    @Autowired
    Utils utils;
    @Autowired
    private EPersonService epersonService;
    @Autowired
    private GroupService groupService;
    @Autowired
    DSpaceObjectUtils dspaceObjectUtils;
    @Autowired
    ResourcePatch<ResourcePolicy> resourcePatch;

    @PreAuthorize(value="hasPermission(#id, 'resourcepolicy', 'READ')")
    public ResourcePolicyRest findOne(Context context, Integer id) {
        ResourcePolicy source = null;
        try {
            source = (ResourcePolicy)this.resourcePolicyService.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (source == null) {
            return null;
        }
        return (ResourcePolicyRest)this.converter.toRest((Object)source, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<ResourcePolicyRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("resourcepolicy", "findAll");
    }

    public Class<ResourcePolicyRest> getDomainClass() {
        return ResourcePolicyRest.class;
    }

    @PreAuthorize(value="hasPermission(#resourceUuid, 'dspaceObject', 'ADMIN')")
    @SearchRestMethod(name="resource")
    public Page<ResourcePolicyRest> findByResource(@Parameter(value="uuid", required=true) UUID resourceUuid, @Parameter(value="action", required=false) String action, Pageable pageable) {
        List resourcePolisies = null;
        int total = 0;
        try {
            Context context = this.obtainContext();
            if (action != null) {
                int actionId = Constants.getActionID((String)action);
                resourcePolisies = this.resourcePolicyService.findByResouceUuidAndActionId(context, resourceUuid, actionId, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getOffset() + (long)pageable.getPageSize()));
                total = this.resourcePolicyService.countByResouceUuidAndActionId(context, resourceUuid, actionId);
            } else {
                resourcePolisies = this.resourcePolicyService.findByResouceUuid(context, resourceUuid, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getOffset() + (long)pageable.getPageSize()));
                total = this.resourcePolicyService.countByResourceUuid(context, resourceUuid);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.converter.toRestPage(resourcePolisies, pageable, (long)total, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasPermission(#epersonUuid, 'EPERSON', 'READ')")
    @SearchRestMethod(name="eperson")
    public Page<ResourcePolicyRest> findByEPerson(@Parameter(value="uuid", required=true) UUID epersonUuid, @Parameter(value="resource", required=false) UUID resourceUuid, Pageable pageable) {
        List resourcePolisies = null;
        int total = 0;
        try {
            Context context = this.obtainContext();
            EPerson eperson = (EPerson)this.epersonService.find(context, epersonUuid);
            if (eperson == null) {
                return null;
            }
            if (resourceUuid != null) {
                resourcePolisies = this.resourcePolicyService.findByEPersonAndResourceUuid(context, eperson, resourceUuid, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getOffset() + (long)pageable.getPageSize()));
                total = this.resourcePolicyService.countResourcePoliciesByEPersonAndResourceUuid(context, eperson, resourceUuid);
            } else {
                resourcePolisies = this.resourcePolicyService.findByEPerson(context, eperson, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getOffset() + (long)pageable.getPageSize()));
                total = this.resourcePolicyService.countByEPerson(context, eperson);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.converter.toRestPage(resourcePolisies, pageable, (long)total, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasPermission(#groupUuid, 'GROUP', 'READ')")
    @SearchRestMethod(name="group")
    public Page<ResourcePolicyRest> findByGroup(@Parameter(value="uuid", required=true) UUID groupUuid, @Parameter(value="resource", required=false) UUID resourceUuid, Pageable pageable) {
        List resourcePolisies = null;
        int total = 0;
        try {
            Context context = this.obtainContext();
            if (context.getCurrentUser() == null) {
                throw new RESTAuthorizationException("Only loggedin users can search resource policies by group");
            }
            Group group = (Group)this.groupService.find(context, groupUuid);
            if (group == null) {
                return null;
            }
            if (resourceUuid != null) {
                resourcePolisies = this.resourcePolicyService.findByGroupAndResourceUuid(context, group, resourceUuid, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getOffset() + (long)pageable.getPageSize()));
                total = this.resourcePolicyService.countByGroupAndResourceUuid(context, group, resourceUuid);
            } else {
                resourcePolisies = this.resourcePolicyService.findByGroup(context, group, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getOffset() + (long)pageable.getPageSize()));
                total = this.resourcePolicyService.countResourcePolicyByGroup(context, group);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.converter.toRestPage(resourcePolisies, pageable, (long)total, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected ResourcePolicyRest createAndReturn(Context context) throws AuthorizeException, SQLException {
        String resourceUuidStr = this.getRequestService().getCurrentRequest().getServletRequest().getParameter("resource");
        String epersonUuidStr = this.getRequestService().getCurrentRequest().getServletRequest().getParameter("eperson");
        String groupUuidStr = this.getRequestService().getCurrentRequest().getServletRequest().getParameter("group");
        if (resourceUuidStr == null) {
            throw new MissingParameterException("Missing resource (uuid) parameter");
        }
        if (epersonUuidStr == null && groupUuidStr == null || epersonUuidStr != null && groupUuidStr != null) {
            throw new MissingParameterException("Both eperson than group parameters supplied, only one allowed");
        }
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        ResourcePolicyRest resourcePolicyRest = null;
        ResourcePolicy resourcePolicy = null;
        UUID resourceUuid = UUID.fromString(resourceUuidStr);
        try {
            resourcePolicyRest = (ResourcePolicyRest)mapper.readValue((InputStream)req.getInputStream(), ResourcePolicyRest.class);
        }
        catch (IOException exIO) {
            throw new UnprocessableEntityException("error parsing the body " + exIO.getMessage(), (Throwable)exIO);
        }
        DSpaceObject dspaceObject = this.dspaceObjectUtils.findDSpaceObject(context, resourceUuid);
        if (dspaceObject == null) {
            throw new UnprocessableEntityException("DSpaceObject with this uuid: " + resourceUuid + " not found");
        }
        resourcePolicy = (ResourcePolicy)this.resourcePolicyService.create(context);
        resourcePolicy.setRpType(resourcePolicyRest.getPolicyType());
        resourcePolicy.setdSpaceObject(dspaceObject);
        resourcePolicy.setRpName(resourcePolicyRest.getName());
        resourcePolicy.setRpDescription(resourcePolicyRest.getDescription());
        resourcePolicy.setAction(Constants.getActionID((String)resourcePolicyRest.getAction()));
        resourcePolicy.setStartDate(resourcePolicyRest.getStartDate());
        resourcePolicy.setEndDate(resourcePolicyRest.getEndDate());
        if (epersonUuidStr != null) {
            try {
                UUID epersonUuid = UUID.fromString(epersonUuidStr);
                EPerson ePerson = (EPerson)this.epersonService.find(context, epersonUuid);
                if (ePerson == null) {
                    throw new UnprocessableEntityException("EPerson with uuid: " + epersonUuid + " not found");
                }
                resourcePolicy.setEPerson(ePerson);
                this.resourcePolicyService.update(context, (Object)resourcePolicy);
            }
            catch (SQLException excSQL) {
                throw new RuntimeException(excSQL.getMessage(), excSQL);
            }
            return (ResourcePolicyRest)this.converter.toRest((Object)resourcePolicy, this.utils.obtainProjection());
        }
        try {
            UUID groupUuid = UUID.fromString(groupUuidStr);
            Group group = (Group)this.groupService.find(context, groupUuid);
            if (group == null) {
                throw new UnprocessableEntityException("Group with uuid: " + groupUuid + " not found");
            }
            resourcePolicy.setGroup(group);
            this.resourcePolicyService.update(context, (Object)resourcePolicy);
        }
        catch (SQLException excSQL) {
            throw new RuntimeException(excSQL.getMessage(), excSQL);
        }
        return (ResourcePolicyRest)this.converter.toRest((Object)resourcePolicy, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected void delete(Context context, Integer id) throws AuthorizeException {
        ResourcePolicy resourcePolicy = null;
        try {
            resourcePolicy = (ResourcePolicy)this.resourcePolicyService.find(context, id.intValue());
            if (resourcePolicy == null) {
                throw new ResourceNotFoundException("authz.resourcepolicy with id: " + id + " not found");
            }
            this.resourcePolicyService.delete(context, (Object)resourcePolicy);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to delete ResourcePolicy with id = " + id, e);
        }
    }

    @PreAuthorize(value="hasPermission(#id, 'resourcepolicy', 'ADMIN')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, Integer id, Patch patch) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        ResourcePolicy resourcePolicy = (ResourcePolicy)this.resourcePolicyService.find(context, id.intValue());
        if (resourcePolicy == null) {
            throw new ResourceNotFoundException("authz.resourcepolicy with id: " + id + " not found");
        }
        this.resourcePatch.patch(this.obtainContext(), (Object)resourcePolicy, patch.getOperations());
        this.resourcePolicyService.update(context, (Object)resourcePolicy);
    }
}

