/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.converter.MetadataConverter;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="eperson.group")
public class GroupRestRepository
extends DSpaceObjectRestRepository<Group, GroupRest> {
    @Autowired
    GroupService gs;
    @Autowired
    MetadataConverter metadataConverter;

    @Autowired
    GroupRestRepository(GroupService dsoService) {
        super((DSpaceObjectService)dsoService);
        this.gs = dsoService;
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected GroupRest createAndReturn(Context context) throws AuthorizeException, RepositoryMethodNotImplementedException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = null;
        try {
            groupRest = (GroupRest)mapper.readValue((InputStream)req.getInputStream(), GroupRest.class);
        }
        catch (IOException excIO) {
            throw new UnprocessableEntityException("error parsing the body ..." + excIO.getMessage());
        }
        Group group = null;
        try {
            group = this.gs.create(context);
            this.gs.setName(group, groupRest.getName());
            this.gs.update(context, (DSpaceObject)group);
            this.metadataConverter.setMetadata(context, (DSpaceObject)group, groupRest.getMetadata());
        }
        catch (SQLException excSQL) {
            throw new RuntimeException(excSQL.getMessage(), excSQL);
        }
        return (GroupRest)this.converter.toRest((Object)group, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasPermission(#id, 'GROUP', 'READ')")
    public GroupRest findOne(Context context, UUID id) {
        Group group = null;
        try {
            group = (Group)this.gs.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (group == null) {
            return null;
        }
        return (GroupRest)this.converter.toRest((Object)group, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<GroupRest> findAll(Context context, Pageable pageable) {
        try {
            long total = this.gs.countTotal(context);
            List groups = this.gs.findAll(context, null, pageable.getPageSize(), Math.toIntExact(pageable.getOffset()));
            return this.converter.toRestPage(groups, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasPermission(#id, 'GROUP', 'WRITE')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    public Class<GroupRest> getDomainClass() {
        return GroupRest.class;
    }
}

