/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.List;
import java.util.Optional;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.ExternalSourceEntryRest;
import org.dspace.app.rest.model.ExternalSourceRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.core.Context;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.ExternalDataProvider;
import org.dspace.external.service.ExternalDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Component;

@Component(value="integration.externalsource")
public class ExternalSourceRestRepository
extends DSpaceRestRepository<ExternalSourceRest, String> {
    @Autowired
    private ExternalDataService externalDataService;
    @Autowired
    ConverterService converter;

    public ExternalSourceEntryRest getExternalSourceEntryValue(String externalSourceName, String entryId) {
        if (this.externalDataService.getExternalDataProvider(externalSourceName) == null) {
            throw new ResourceNotFoundException("The externalSource for: " + externalSourceName + " couldn't be found");
        }
        Optional externalDataObject = this.externalDataService.getExternalDataObject(externalSourceName, entryId);
        ExternalDataObject dataObject = (ExternalDataObject)externalDataObject.orElseThrow(() -> new ResourceNotFoundException("Couldn't find an ExternalSource for source: " + externalSourceName + " and ID: " + entryId));
        return (ExternalSourceEntryRest)this.converter.toRest((Object)dataObject, this.utils.obtainProjection());
    }

    public Page<ExternalSourceEntryRest> getExternalSourceEntries(String externalSourceName, String query, String parent, Pageable pageable) {
        if (this.externalDataService.getExternalDataProvider(externalSourceName) == null) {
            throw new ResourceNotFoundException("The externalSource for: " + externalSourceName + " couldn't be found");
        }
        List externalDataObjects = this.externalDataService.searchExternalDataObjects(externalSourceName, query, Math.toIntExact(pageable.getOffset()), pageable.getPageSize());
        int numberOfResults = this.externalDataService.getNumberOfResults(externalSourceName, query);
        return this.converter.toRestPage(externalDataObjects, pageable, (long)numberOfResults, this.utils.obtainProjection());
    }

    public ExternalSourceRest findOne(Context context, String externalSourceName) {
        ExternalDataProvider externalDataProvider = this.externalDataService.getExternalDataProvider(externalSourceName);
        if (externalDataProvider == null) {
            throw new ResourceNotFoundException("ExternalDataProvider for: " + externalSourceName + " couldn't be found");
        }
        return (ExternalSourceRest)this.converter.toRest((Object)externalDataProvider, this.utils.obtainProjection());
    }

    public Page<ExternalSourceRest> findAll(Context context, Pageable pageable) {
        List externalSources = this.externalDataService.getExternalDataProviders();
        return this.converter.toRestPage(externalSources, pageable, (long)externalSources.size(), this.utils.obtainProjection());
    }

    public Class<ExternalSourceRest> getDomainClass() {
        return ExternalSourceRest.class;
    }
}

