/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model.hateoas;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.dspace.app.rest.model.hateoas.EmbeddedPageHeader;
import org.dspace.app.rest.utils.URLUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.web.util.UriComponentsBuilder;

public class EmbeddedPageHeader {
    protected Page page;
    protected boolean totalElementsIsKnown;
    protected UriComponentsBuilder self;

    public EmbeddedPageHeader(UriComponentsBuilder self, Page page, boolean totalElementsIsKnown) {
        this.page = page;
        this.self = self;
        this.totalElementsIsKnown = totalElementsIsKnown;
    }

    public EmbeddedPageHeader(String self, Page page, boolean totalElementsIsKnown) {
        this(UriComponentsBuilder.fromUriString((String)URLUtils.decode((String)self)), page, totalElementsIsKnown);
    }

    public EmbeddedPageHeader(UriComponentsBuilder self, Page page) {
        this(self, page, true);
    }

    @JsonProperty(value="page")
    public Map<String, Long> getPageInfo() {
        HashMap<String, Long> pageInfo = new HashMap<String, Long>();
        pageInfo.put("number", Long.valueOf(this.page.getNumber()));
        pageInfo.put("size", (long)this.page.getSize() != 0L ? (long)this.page.getSize() : this.page.getTotalElements());
        if (this.totalElementsIsKnown) {
            pageInfo.put("totalPages", Long.valueOf(this.page.getTotalPages()));
            pageInfo.put("totalElements", this.page.getTotalElements());
        }
        return pageInfo;
    }

    @JsonProperty(value="_links")
    public Map<String, Object> getLinks() {
        HashMap<String, Object> links = new HashMap<String, Object>();
        if (!this.page.isFirst()) {
            links.put("first", this._link(this.page.getSort(), Integer.valueOf(0), this.page.getSize()));
            links.put("self", this._link(this.page.getSort(), Integer.valueOf(this.page.getNumber()), this.page.getSize()));
        } else {
            links.put("self", this._link(this.page.getSort(), null, this.page.getSize()));
        }
        if (!this.page.isLast() && this.totalElementsIsKnown) {
            links.put("last", this._link(this.page.getSort(), Integer.valueOf(this.page.getTotalPages() - 1), this.page.getSize()));
        }
        if (this.page.hasPrevious()) {
            links.put("prev", this._link(this.page.getSort(), Integer.valueOf(this.page.getNumber() - 1), this.page.getSize()));
        }
        if (this.page.hasNext()) {
            links.put("next", this._link(this.page.getSort(), Integer.valueOf(this.page.getNumber() + 1), this.page.getSize()));
        }
        return links;
    }

    private Href _link(Sort sort, Integer i, int size) {
        UriComponentsBuilder uriComp = this.self.cloneBuilder();
        if (sort != null) {
            for (Sort.Order order : sort) {
                uriComp = uriComp.queryParam("sort", new Object[]{order.getProperty() + "," + order.getDirection()});
            }
        }
        if (i != null) {
            uriComp = uriComp.queryParam("page", new Object[]{i});
            uriComp = uriComp.queryParam("size", new Object[]{size});
        }
        return new Href(this, uriComp.build().toUriString());
    }
}

