/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.link.HalLinkFactory;
import org.dspace.app.rest.model.hateoas.EmbeddedPage;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@ComponentScan
public class HalLinkService {
    private static final Logger log = LogManager.getLogger(HalLinkService.class);
    @Autowired
    private List<HalLinkFactory> halLinkFactories;
    private Map<String, List<HalLinkFactory>> cachedMappings = new ConcurrentHashMap();

    public void addLinks(HALResource halResource, Pageable pageable) throws Exception {
        LinkedList links = new LinkedList();
        List supportedFactories = this.getSupportedFactories(halResource);
        for (HalLinkFactory halLinkFactory : supportedFactories) {
            links.addAll(halLinkFactory.getLinksFor(halResource, pageable));
        }
        links.sort((l1, l2) -> ObjectUtils.compare((Comparable)((Object)l1.getRel()), (Comparable)((Object)l2.getRel())));
        halResource.add(links);
        for (Object obj : halResource.getEmbeddedResources().values()) {
            if (obj instanceof Collection) {
                for (Object e : (Collection)obj) {
                    if (!(e instanceof HALResource)) continue;
                    this.addLinks((HALResource)e);
                }
                continue;
            }
            if (obj instanceof Map) {
                for (Object object : ((Map)obj).values()) {
                    if (!(object instanceof HALResource)) continue;
                    this.addLinks((HALResource)object);
                }
                continue;
            }
            if (obj instanceof EmbeddedPage) {
                for (Map.Entry entry : ((EmbeddedPage)obj).getPageContent().entrySet()) {
                    for (Object subObj : CollectionUtils.emptyIfNull((Collection)((Collection)entry.getValue()))) {
                        if (!(subObj instanceof HALResource)) continue;
                        this.addLinks((HALResource)subObj);
                    }
                }
                continue;
            }
            if (!(obj instanceof HALResource)) continue;
            this.addLinks((HALResource)obj);
        }
    }

    private List<HalLinkFactory> getSupportedFactories(HALResource halResource) {
        List factories = (List)this.cachedMappings.get(this.getKey(halResource));
        if (factories == null) {
            factories = this.halLinkFactories.stream().filter(halLinkFactory -> halLinkFactory.supports(halResource.getClass())).collect(Collectors.toList());
            this.cachedMappings.put(this.getKey(halResource), factories);
        }
        return factories;
    }

    private String getKey(HALResource halResource) {
        return halResource.getClass().getCanonicalName();
    }

    public HALResource addLinks(HALResource halResource) {
        try {
            this.addLinks(halResource, null);
        }
        catch (Exception ex) {
            log.warn("Unable to add links to HAL resource " + halResource, (Throwable)ex);
        }
        return halResource;
    }
}

