/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.BitstreamResource;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.MultipartFileSender;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.disseminate.service.CitationDocumentService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.EventService;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/bitstreams/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"})
public class BitstreamRestController {
    private static final Logger log = LogManager.getLogger(BitstreamRestController.class);
    private static final int BUFFER_SIZE = 40960;
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    BitstreamFormatService bitstreamFormatService;
    @Autowired
    private EventService eventService;
    @Autowired
    private CitationDocumentService citationDocumentService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    ConverterService converter;
    @Autowired
    Utils utils;

    @PreAuthorize(value="hasPermission(#uuid, 'BITSTREAM', 'READ')")
    @RequestMapping(method={RequestMethod.GET, RequestMethod.HEAD}, value={"content"})
    public void retrieve(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws IOException, SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        Bitstream bit = this.bitstreamService.find(context, uuid);
        if (bit == null) {
            response.sendError(404);
            return;
        }
        Long lastModified = this.bitstreamService.getLastModified(bit);
        BitstreamFormat format = bit.getFormat(context);
        String mimetype = format.getMIMEType();
        String name = this.getBitstreamName(bit, format);
        Pair bitstreamTuple = this.getBitstreamInputStreamAndSize(context, bit);
        try (InputStream is = (InputStream)bitstreamTuple.getLeft();){
            long dispositionThreshold;
            MultipartFileSender sender = MultipartFileSender.fromInputStream((InputStream)is).withBufferSize(40960).withFileName(name).withLength(((Long)bitstreamTuple.getRight()).longValue()).withChecksum(bit.getChecksum()).withMimetype(mimetype).with(request).with(response);
            if (lastModified != null) {
                sender.withLastModified(lastModified.longValue());
            }
            if ((dispositionThreshold = this.configurationService.getLongProperty("webui.content_disposition_threshold")) >= 0L && (Long)bitstreamTuple.getRight() > dispositionThreshold) {
                sender.withDisposition("attachment");
            }
            if (sender.isNoRangeRequest() && this.isNotAnErrorResponse(response)) {
                this.eventService.fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, (DSpaceObject)bit));
            }
            context.complete();
            if (sender.isValid()) {
                sender.serveResource();
            }
        }
        catch (ClientAbortException ex) {
            log.debug("Client aborted the request before the download was completed. Client is probably switching to a Range request.", (Throwable)ex);
        }
    }

    private Pair<InputStream, Long> getBitstreamInputStreamAndSize(Context context, Bitstream bit) throws SQLException, IOException, AuthorizeException {
        if (this.citationDocumentService.isCitationEnabledForBitstream(bit, context).booleanValue()) {
            return this.generateBitstreamWithCitation(context, bit);
        }
        return Pair.of((Object)this.bitstreamService.retrieve(context, bit), (Object)bit.getSizeBytes());
    }

    private Pair<InputStream, Long> generateBitstreamWithCitation(Context context, Bitstream bitstream) throws SQLException, IOException, AuthorizeException {
        Pair citationDocument = this.citationDocumentService.makeCitedDocument(context, bitstream);
        if (citationDocument.getLeft() == null) {
            log.error("CitedDocument was null");
        } else if (log.isDebugEnabled()) {
            log.debug("CitedDocument was ok, has size " + citationDocument.getRight());
        }
        return citationDocument;
    }

    private String getBitstreamName(Bitstream bit, BitstreamFormat format) {
        Object name = bit.getName();
        if (name == null) {
            name = bit.getID().toString();
            if (format != null && format.getExtensions() != null && format.getExtensions().size() > 0) {
                name = (String)name + "." + (String)format.getExtensions().get(0);
            }
        }
        return name;
    }

    private boolean isNotAnErrorResponse(HttpServletResponse response) {
        Response.Status.Family responseCode = Response.Status.Family.familyOf((int)response.getStatus());
        return responseCode.equals((Object)Response.Status.Family.SUCCESSFUL) || responseCode.equals((Object)Response.Status.Family.REDIRECTION);
    }

    @RequestMapping(method={RequestMethod.PUT}, consumes={"text/uri-list"}, value={"format"})
    @PreAuthorize(value="hasPermission(#uuid, 'BITSTREAM','WRITE')")
    @PostAuthorize(value="returnObject != null")
    public BitstreamResource updateBitstreamFormat(@PathVariable UUID uuid, HttpServletRequest request) throws SQLException {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        List bitstreamFormats = this.utils.constructBitstreamFormatList(request, context);
        if (bitstreamFormats.size() > 1) {
            throw new DSpaceBadRequestException("Only one bitstream format is allowed");
        }
        BitstreamFormat bitstreamFormat = (BitstreamFormat)bitstreamFormats.stream().findFirst().orElseThrow(() -> new DSpaceBadRequestException("No valid bitstream format was provided"));
        Bitstream bitstream = this.bitstreamService.find(context, uuid);
        if (bitstream == null) {
            throw new ResourceNotFoundException("Bitstream with id: " + uuid + " not found");
        }
        bitstream.setFormat(context, bitstreamFormat);
        context.commit();
        BitstreamRest bitstreamRest = (BitstreamRest)this.converter.toRest((Object)((Bitstream)context.reloadEntity((ReloadableEntity)bitstream)), this.utils.obtainProjection());
        return (BitstreamResource)this.converter.toResource((RestModel)bitstreamRest);
    }
}

