/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.step.DataDescribe;
import org.dspace.app.rest.submit.AbstractRestProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.factory.PatchOperationFactory;
import org.dspace.app.rest.submit.factory.impl.PatchOperation;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.services.model.Request;

public class DescribeStep
extends org.dspace.submit.step.DescribeStep
implements AbstractRestProcessingStep {
    private static final Logger log = LogManager.getLogger(DescribeStep.class);
    private DCInputsReader inputReader = new DCInputsReader();

    public DataDescribe getData(SubmissionService submissionService, InProgressSubmission obj, SubmissionStepConfig config) {
        DataDescribe data = new DataDescribe();
        try {
            DCInputSet inputConfig = this.inputReader.getInputsByFormName(config.getId());
            this.readField(obj, config, data, inputConfig);
        }
        catch (DCInputsReaderException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return data;
    }

    private void readField(InProgressSubmission obj, SubmissionStepConfig config, DataDescribe data, DCInputSet inputConfig) throws DCInputsReaderException {
        DCInput[][] dCInputArray = inputConfig.getFields();
        int n = dCInputArray.length;
        for (int i = 0; i < n; ++i) {
            DCInput[] row;
            for (DCInput input : row = dCInputArray[i]) {
                ArrayList<Object> fieldsName = new ArrayList<Object>();
                if (input.isQualdropValue()) {
                    for (Object e : input.getPairs()) {
                        fieldsName.add(input.getFieldName() + "." + (String)e);
                    }
                } else {
                    fieldsName.add(input.getFieldName());
                }
                for (String string : fieldsName) {
                    List mdv = this.itemService.getMetadataByMetadataString((DSpaceObject)obj.getItem(), string);
                    for (MetadataValue md : mdv) {
                        MetadataValueRest dto = new MetadataValueRest();
                        dto.setAuthority(md.getAuthority());
                        dto.setConfidence(md.getConfidence());
                        dto.setLanguage(md.getLanguage());
                        dto.setPlace(md.getPlace());
                        dto.setValue(md.getValue());
                        String[] metadataToCheck = Utils.tokenize((String)md.getMetadataField().toString());
                        if (data.getMetadata().containsKey(Utils.standardize((String)metadataToCheck[0], (String)metadataToCheck[1], (String)metadataToCheck[2], (String)"."))) {
                            data.getMetadata().get(Utils.standardize((String)md.getMetadataField().getMetadataSchema().getName(), (String)md.getMetadataField().getElement(), (String)md.getMetadataField().getQualifier(), (String)".")).add(dto);
                            continue;
                        }
                        ArrayList<MetadataValueRest> listDto = new ArrayList<MetadataValueRest>();
                        listDto.add(dto);
                        data.getMetadata().put(Utils.standardize((String)md.getMetadataField().getMetadataSchema().getName(), (String)md.getMetadataField().getElement(), (String)md.getMetadataField().getQualifier(), (String)"."), listDto);
                    }
                }
            }
        }
    }

    @Override
    public void doPatchProcessing(Context context, Request currentRequest, InProgressSubmission source, Operation op) throws Exception {
        PatchOperation patchOperation = new PatchOperationFactory().instanceOf("itemmetadata", op.getOp());
        patchOperation.perform(context, currentRequest, source, op);
    }
}

