/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import java.util.Date;
import java.util.List;
import org.dspace.app.rest.model.ResourcePolicyRest;
import org.dspace.app.rest.model.patch.LateObjectEvaluator;
import org.dspace.app.rest.submit.factory.impl.ReplacePatchOperation;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.model.Request;
import org.springframework.beans.factory.annotation.Autowired;

public class ResourcePolicyReplacePatchOperation
extends ReplacePatchOperation<ResourcePolicyRest> {
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    ItemService itemService;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    ResourcePolicyService resourcePolicyService;
    @Autowired
    GroupService groupService;
    @Autowired
    EPersonService epersonService;

    @Override
    void replace(Context context, Request currentRequest, InProgressSubmission source, String path, Object value) throws Exception {
        String[] split = this.getAbsolutePath(path).split("/");
        Item item = source.getItem();
        List bundle = this.itemService.getBundles(item, "ORIGINAL");
        for (Bundle bb : bundle) {
            int idx = 0;
            for (Bitstream b : bb.getBitstreams()) {
                if (idx == Integer.parseInt(split[1])) {
                    List policies = this.authorizeService.findPoliciesByDSOAndType(context, (DSpaceObject)b, ResourcePolicy.TYPE_CUSTOM);
                    String rpIdx = split[3];
                    int index = 0;
                    for (ResourcePolicy policy : policies) {
                        Integer toReplace = Integer.parseInt(rpIdx);
                        if (index == toReplace) {
                            b.getResourcePolicies().remove(policy);
                            break;
                        }
                        ++index;
                    }
                    if (split.length == 4) {
                        ResourcePolicyRest newAccessCondition = (ResourcePolicyRest)this.evaluateSingleObject((LateObjectEvaluator)value);
                        String name = newAccessCondition.getName();
                        String description = newAccessCondition.getDescription();
                        Group group = null;
                        if (newAccessCondition.getGroupUUID() != null) {
                            group = (Group)this.groupService.find(context, newAccessCondition.getGroupUUID());
                        }
                        EPerson eperson = null;
                        if (newAccessCondition.getEpersonUUID() != null) {
                            eperson = (EPerson)this.epersonService.find(context, newAccessCondition.getEpersonUUID());
                        }
                        Date startDate = newAccessCondition.getStartDate();
                        Date endDate = newAccessCondition.getEndDate();
                        this.authorizeService.createResourcePolicy(context, (DSpaceObject)b, group, eperson, 0, ResourcePolicy.TYPE_CUSTOM, name, description, startDate, endDate);
                    }
                }
                ++idx;
            }
        }
    }

    @Override
    protected Class<ResourcePolicyRest[]> getArrayClassForEvaluation() {
        return ResourcePolicyRest[].class;
    }

    @Override
    protected Class<ResourcePolicyRest> getClassForEvaluation() {
        return ResourcePolicyRest.class;
    }
}

