/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.dspace.util.UUIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuthorizeServicePermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(AuthorizeServicePermissionEvaluatorPlugin.class);
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RequestService requestService;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private ContentServiceFactory contentServiceFactory;

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (restPermission == null) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext(request.getServletRequest());
        EPerson ePerson = null;
        try {
            DSpaceObjectService dSpaceObjectService;
            UUID dsoId = UUIDUtils.fromString((String)targetId.toString());
            try {
                dSpaceObjectService = this.contentServiceFactory.getDSpaceObjectService(Constants.getTypeID((String)targetType));
            }
            catch (UnsupportedOperationException e) {
                return false;
            }
            ePerson = this.ePersonService.findByEmail(context, (String)authentication.getPrincipal());
            if (dSpaceObjectService != null && dsoId != null) {
                DSpaceObject dSpaceObject = dSpaceObjectService.find(context, dsoId);
                if (dSpaceObject == null) {
                    return true;
                }
                return this.authorizeService.authorizeActionBoolean(context, ePerson, dSpaceObject, restPermission.getDspaceApiActionId(), false);
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

