/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.springframework.stereotype.Component;

@Component
public class EPersonPasswordReplaceOperation<R>
extends PatchOperation<R> {
    public static final String OPERATION_PASSWORD_CHANGE = "/password";
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();

    @Override
    public R perform(Context context, R object, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(object, operation)) {
            EPerson eperson = (EPerson)object;
            this.checkModelForExistingValue(eperson);
            this.ePersonService.setPassword(eperson, (String)operation.getValue());
            return object;
        }
        throw new DSpaceBadRequestException("EPersonPasswordReplaceOperation does not support this operation");
    }

    private void checkModelForExistingValue(EPerson ePerson) {
        if (this.ePersonService.getPasswordHash(ePerson) == null || this.ePersonService.getPasswordHash(ePerson).getHash() == null) {
            throw new DSpaceBadRequestException("Attempting to replace a non-existent value (netID).");
        }
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof EPerson && operation.getOp().trim().equalsIgnoreCase("replace") && operation.getPath().trim().equalsIgnoreCase(OPERATION_PASSWORD_CHANGE);
    }
}

