/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.DSpaceObjectMetadataPatchUtils;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DSpaceObjectMetadataReplaceOperation<R extends DSpaceObject>
extends PatchOperation<R> {
    @Autowired
    DSpaceObjectMetadataPatchUtils metadataPatchUtils;

    @Override
    public R perform(Context context, R resource, Operation operation) throws SQLException {
        DSpaceObjectService dsoService = ContentServiceFactory.getInstance().getDSpaceObjectService(resource);
        MetadataField metadataField = this.metadataPatchUtils.getMetadataField(context, operation);
        String[] partsOfPath = operation.getPath().split("/");
        String indexInPath = partsOfPath.length > 3 ? partsOfPath[3] : null;
        MetadataValueRest metadataValueToReplace = this.metadataPatchUtils.extractMetadataValueFromOperation(operation);
        String propertyOfMd = this.metadataPatchUtils.extractPropertyOfMdFromPath(partsOfPath);
        String newValueMdAttribute = this.metadataPatchUtils.extractNewValueOfMd(operation);
        this.replace(context, (DSpaceObject)resource, dsoService, metadataField, metadataValueToReplace, indexInPath, propertyOfMd, newValueMdAttribute);
        return resource;
    }

    private void replace(Context context, DSpaceObject dso, DSpaceObjectService dsoService, MetadataField metadataField, MetadataValueRest metadataValue, String index, String propertyOfMd, String valueMdProperty) {
        if (metadataField == null) {
            this.replaceAllMetadata(context, dso, dsoService);
            return;
        }
        if (index == null) {
            this.replaceMetadataFieldMetadata(context, dso, dsoService, metadataField, metadataValue);
            return;
        }
        if (propertyOfMd == null) {
            this.replaceSingleMetadataValue(dso, dsoService, metadataField, metadataValue, index);
            return;
        }
        this.replaceSinglePropertyOfMdValue(dso, dsoService, metadataField, index, propertyOfMd, valueMdProperty);
    }

    private void replaceAllMetadata(Context context, DSpaceObject dso, DSpaceObjectService dsoService) {
        try {
            dsoService.clearMetadata(context, dso, "*", "*", "*", "*");
        }
        catch (SQLException e) {
            throw new DSpaceBadRequestException("SQLException in DspaceObjectMetadataOperation.replace trying to remove and replace metadata from dso.", e);
        }
    }

    private void replaceMetadataFieldMetadata(Context context, DSpaceObject dso, DSpaceObjectService dsoService, MetadataField metadataField, MetadataValueRest metadataValue) {
        try {
            dsoService.clearMetadata(context, dso, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier(), "*");
            dsoService.addAndShiftRightMetadata(context, dso, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier(), metadataValue.getLanguage(), metadataValue.getValue(), metadataValue.getAuthority(), metadataValue.getConfidence(), -1);
        }
        catch (SQLException e) {
            throw new DSpaceBadRequestException("SQLException in DspaceObjectMetadataOperation.replace trying to remove and replace metadata from dso.", e);
        }
    }

    private void replaceSingleMetadataValue(DSpaceObject dso, DSpaceObjectService dsoService, MetadataField metadataField, MetadataValueRest metadataValue, String index) {
        try {
            List metadataValues = dsoService.getMetadata(dso, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier(), "*");
            int indexInt = Integer.parseInt(index);
            if (indexInt < 0 || metadataValues.size() <= indexInt || metadataValues.get(indexInt) == null) {
                throw new UnprocessableEntityException("There is no metadata of this type at that index");
            }
            MetadataValue existingMdv = (MetadataValue)metadataValues.get(indexInt);
            existingMdv.setAuthority(metadataValue.getAuthority());
            existingMdv.setConfidence(metadataValue.getConfidence());
            existingMdv.setLanguage(metadataValue.getLanguage());
            existingMdv.setValue(metadataValue.getValue());
            dsoService.setMetadataModified(dso);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("This index (" + index + ") is not valid number.", e);
        }
    }

    private void replaceSinglePropertyOfMdValue(DSpaceObject dso, DSpaceObjectService dsoService, MetadataField metadataField, String index, String propertyOfMd, String valueMdProperty) {
        try {
            List metadataValues = dsoService.getMetadata(dso, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier(), "*");
            int indexInt = Integer.parseInt(index);
            if (indexInt >= 0 && metadataValues.size() > indexInt && metadataValues.get(indexInt) != null) {
                MetadataValue existingMdv = (MetadataValue)metadataValues.get(indexInt);
                if (propertyOfMd.equals("authority")) {
                    existingMdv.setAuthority(valueMdProperty);
                }
                if (propertyOfMd.equals("confidence")) {
                    existingMdv.setConfidence(Integer.valueOf(valueMdProperty).intValue());
                }
                if (propertyOfMd.equals("language")) {
                    existingMdv.setLanguage(valueMdProperty);
                }
                if (propertyOfMd.equals("value")) {
                    existingMdv.setValue(valueMdProperty);
                }
            } else {
                throw new UnprocessableEntityException("There is no metadata of this type at that index");
            }
            dsoService.setMetadataModified(dso);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not all numbers are valid numbers. (Index and confidence should be nr)", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        if (!operation.getPath().startsWith("/metadata")) {
            if (!operation.getPath().equals("/metadata")) return false;
        }
        if (!operation.getOp().trim().equalsIgnoreCase("replace")) return false;
        if (!(objectToMatch instanceof DSpaceObject)) return false;
        return true;
    }
}

