/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.CopyOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.DSpaceObjectMetadataPatchUtils;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DSpaceObjectMetadataCopyOperation<R extends DSpaceObject>
extends PatchOperation<R> {
    @Autowired
    DSpaceObjectMetadataPatchUtils metadataPatchUtils;

    @Override
    public R perform(Context context, R resource, Operation operation) throws SQLException {
        DSpaceObjectService dsoService = ContentServiceFactory.getInstance().getDSpaceObjectService(resource);
        MetadataField metadataField = this.metadataPatchUtils.getMetadataField(context, operation);
        String[] partsFromCopy = ((CopyOperation)operation).getFrom().split("/");
        String indexToCopyFrom = partsFromCopy.length > 3 ? partsFromCopy[3] : null;
        this.copy(context, (DSpaceObject)resource, dsoService, metadataField, indexToCopyFrom);
        return resource;
    }

    private void copy(Context context, DSpaceObject dso, DSpaceObjectService dsoService, MetadataField metadataField, String indexToCopyFrom) {
        this.metadataPatchUtils.checkMetadataFieldNotNull(metadataField);
        List metadataValues = dsoService.getMetadata(dso, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier(), "*");
        try {
            int indexToCopyFromInt = Integer.parseInt(indexToCopyFrom);
            if (indexToCopyFromInt < 0 || metadataValues.size() <= indexToCopyFromInt || metadataValues.get(indexToCopyFromInt) == null) {
                throw new UnprocessableEntityException("There is no metadata of this type at that index");
            }
            MetadataValue metadataValueToCopy = (MetadataValue)metadataValues.get(indexToCopyFromInt);
            MetadataValueRest metadataValueRestToCopy = this.metadataPatchUtils.convertMdValueToRest(metadataValueToCopy);
            dsoService.addAndShiftRightMetadata(context, dso, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier(), metadataValueRestToCopy.getLanguage(), metadataValueRestToCopy.getValue(), metadataValueRestToCopy.getAuthority(), metadataValueRestToCopy.getConfidence(), -1);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("This index (" + indexToCopyFrom + ") is not valid number.", e);
        }
        catch (SQLException e) {
            throw new DSpaceBadRequestException("SQLException in DspaceObjectMetadataCopyOperation.copy trying to add metadata to dso.", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        if (!operation.getPath().startsWith("/metadata")) {
            if (!operation.getPath().equals("/metadata")) return false;
        }
        if (!operation.getOp().trim().equalsIgnoreCase("copy")) return false;
        if (!(objectToMatch instanceof DSpaceObject)) return false;
        return true;
    }
}

