/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.DSpaceObjectMetadataPatchUtils;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DSpaceObjectMetadataAddOperation<R extends DSpaceObject>
extends PatchOperation<R> {
    @Autowired
    DSpaceObjectMetadataPatchUtils metadataPatchUtils;

    @Override
    public R perform(Context context, R resource, Operation operation) throws SQLException {
        DSpaceObjectService dsoService = ContentServiceFactory.getInstance().getDSpaceObjectService(resource);
        MetadataValueRest metadataValueToAdd = this.metadataPatchUtils.extractMetadataValueFromOperation(operation);
        MetadataField metadataField = this.metadataPatchUtils.getMetadataField(context, operation);
        String indexInPath = this.metadataPatchUtils.getIndexFromPath(operation.getPath());
        this.add(context, (DSpaceObject)resource, dsoService, metadataField, metadataValueToAdd, indexInPath);
        return resource;
    }

    private void add(Context context, DSpaceObject dso, DSpaceObjectService dsoService, MetadataField metadataField, MetadataValueRest metadataValue, String index) {
        this.metadataPatchUtils.checkMetadataFieldNotNull(metadataField);
        int indexInt = 0;
        if (index != null && index.equals("-")) {
            indexInt = -1;
        }
        try {
            dsoService.addAndShiftRightMetadata(context, dso, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier(), metadataValue.getLanguage(), metadataValue.getValue(), metadataValue.getAuthority(), metadataValue.getConfidence(), indexInt);
        }
        catch (SQLException e) {
            throw new DSpaceBadRequestException("SQLException in DspaceObjectMetadataAddOperation.add trying to add metadata to dso.", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        if (!operation.getPath().startsWith("/metadata")) {
            if (!operation.getPath().equals("/metadata")) return false;
        }
        if (!operation.getOp().trim().equalsIgnoreCase("add")) return false;
        if (!(objectToMatch instanceof DSpaceObject)) return false;
        return true;
    }
}

