/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.converter.JsonPatchConverter;
import org.dspace.app.rest.model.TemplateItemRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.model.wrapper.TemplateItem;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.ItemRestRepository;
import org.dspace.app.rest.repository.patch.ResourcePatch;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Component;

@Component(value="core.itemtemplate")
public class TemplateItemRestRepository
extends DSpaceRestRepository<TemplateItemRest, UUID> {
    @Autowired
    private ItemService itemService;
    @Autowired
    private ItemRestRepository itemRestRepository;
    @Autowired
    private CollectionService collectionService;
    @Autowired
    ResourcePatch<Item> resourcePatch;

    @Override
    public TemplateItemRest findOne(Context context, UUID uuid) {
        Item item = null;
        try {
            item = (Item)this.itemService.find(context, uuid);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (item == null) {
            return null;
        }
        try {
            return (TemplateItemRest)this.converter.toRest(new TemplateItem(item), this.utils.obtainProjection());
        }
        catch (IllegalArgumentException e) {
            throw new ResourceNotFoundException("The item with id " + item.getID() + " is not a template item");
        }
    }

    @Override
    public Page<TemplateItemRest> findAll(Context context, Pageable pageable) {
        return null;
    }

    @Override
    public Class<TemplateItemRest> getDomainClass() {
        return TemplateItemRest.class;
    }

    public TemplateItemRest patchTemplateItem(TemplateItem templateItem, JsonNode jsonNode) throws SQLException, AuthorizeException {
        ObjectMapper mapper = new ObjectMapper();
        JsonPatchConverter patchConverter = new JsonPatchConverter(mapper);
        Patch patch = patchConverter.convert(jsonNode);
        Item item = templateItem.getItem();
        this.resourcePatch.patch(this.obtainContext(), item, patch.getOperations());
        this.itemService.update(this.obtainContext(), (DSpaceObject)item);
        return this.findById(templateItem.getID()).orElse(null);
    }

    public void removeTemplateItem(Context context, TemplateItem templateItem) throws SQLException, IOException, AuthorizeException {
        Collection collection = templateItem.getItem().getTemplateItemOf();
        this.collectionService.removeTemplateItem(context, collection);
        this.collectionService.update(context, (DSpaceObject)collection);
    }
}

