/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.app.rest.model.ProcessRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.core.Context;
import org.dspace.scripts.Process;
import org.dspace.scripts.service.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="system.process")
public class ProcessRestRepository
extends DSpaceRestRepository<ProcessRest, Integer> {
    private static final Logger log = Logger.getLogger(ProcessRestRepository.class);
    @Autowired
    private ProcessService processService;

    @Override
    @PreAuthorize(value="hasPermission(#id, 'PROCESS', 'READ')")
    public ProcessRest findOne(Context context, Integer id) {
        try {
            Process process = this.processService.find(context, id.intValue());
            if (process == null) {
                return null;
            }
            return (ProcessRest)this.converter.toRest(process, this.utils.obtainProjection());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<ProcessRest> findAll(Context context, Pageable pageable) {
        try {
            int total = this.processService.countTotal(context);
            List processes = this.processService.findAll(context, pageable.getPageSize(), Math.toIntExact(pageable.getOffset()));
            return this.converter.toRestPage(processes, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Class<ProcessRest> getDomainClass() {
        return ProcessRest.class;
    }
}

