/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.MetadataSchemaRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.metadataschema")
public class MetadataSchemaRestRepository
extends DSpaceRestRepository<MetadataSchemaRest, Integer> {
    @Autowired
    MetadataSchemaService metadataSchemaService;

    @Override
    public MetadataSchemaRest findOne(Context context, Integer id) {
        MetadataSchema metadataSchema = null;
        try {
            metadataSchema = this.metadataSchemaService.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (metadataSchema == null) {
            return null;
        }
        return (MetadataSchemaRest)this.converter.toRest(metadataSchema, this.utils.obtainProjection());
    }

    @Override
    public Page<MetadataSchemaRest> findAll(Context context, Pageable pageable) {
        try {
            List metadataSchemas = this.metadataSchemaService.findAll(context);
            return this.converter.toRestPage(this.utils.getPage(metadataSchemas, pageable), this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Class<MetadataSchemaRest> getDomainClass() {
        return MetadataSchemaRest.class;
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected MetadataSchemaRest createAndReturn(Context context) throws AuthorizeException, SQLException {
        MetadataSchema metadataSchema;
        MetadataSchemaRest metadataSchemaRest;
        try {
            metadataSchemaRest = (MetadataSchemaRest)new ObjectMapper().readValue((InputStream)this.getRequestService().getCurrentRequest().getHttpServletRequest().getInputStream(), MetadataSchemaRest.class);
        }
        catch (IOException excIO) {
            throw new DSpaceBadRequestException("error parsing request body", excIO);
        }
        if (StringUtils.isBlank((CharSequence)metadataSchemaRest.getPrefix())) {
            throw new UnprocessableEntityException("metadata schema name cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)metadataSchemaRest.getNamespace())) {
            throw new UnprocessableEntityException("metadata schema namespace cannot be blank");
        }
        try {
            metadataSchema = this.metadataSchemaService.create(context, metadataSchemaRest.getPrefix(), metadataSchemaRest.getNamespace());
            this.metadataSchemaService.update(context, metadataSchema);
        }
        catch (NonUniqueMetadataException e) {
            throw new UnprocessableEntityException("metadata schema " + metadataSchemaRest.getPrefix() + "." + metadataSchemaRest.getNamespace() + " already exists");
        }
        return (MetadataSchemaRest)this.converter.toRest(metadataSchema, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected void delete(Context context, Integer id) throws AuthorizeException {
        try {
            MetadataSchema metadataSchema = this.metadataSchemaService.find(context, id.intValue());
            if (metadataSchema == null) {
                throw new ResourceNotFoundException("metadata schema with id: " + id + " not found");
            }
            this.metadataSchemaService.delete(context, metadataSchema);
        }
        catch (SQLException e) {
            throw new RuntimeException("error while trying to delete metadataschema with id: " + id, e);
        }
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected MetadataSchemaRest put(Context context, HttpServletRequest request, String apiCategory, String model, Integer id, JsonNode jsonNode) throws SQLException, AuthorizeException {
        MetadataSchemaRest metadataSchemaRest = (MetadataSchemaRest)new Gson().fromJson(jsonNode.toString(), MetadataSchemaRest.class);
        if (StringUtils.isBlank((CharSequence)metadataSchemaRest.getPrefix())) {
            throw new UnprocessableEntityException("metadata schema name cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)metadataSchemaRest.getNamespace())) {
            throw new UnprocessableEntityException("metadata schema namespace cannot be blank");
        }
        if (!Objects.equals(id, metadataSchemaRest.getId())) {
            throw new UnprocessableEntityException("ID in request doesn't match path ID");
        }
        MetadataSchema metadataSchema = this.metadataSchemaService.find(context, id.intValue());
        if (metadataSchema == null) {
            throw new ResourceNotFoundException("metadata schema with id: " + id + " not found");
        }
        metadataSchema.setName(metadataSchemaRest.getPrefix());
        metadataSchema.setNamespace(metadataSchemaRest.getNamespace());
        try {
            this.metadataSchemaService.update(context, metadataSchema);
            context.commit();
        }
        catch (NonUniqueMetadataException e) {
            throw new UnprocessableEntityException("metadata schema " + metadataSchemaRest.getPrefix() + "." + metadataSchemaRest.getNamespace() + " already exists");
        }
        return (MetadataSchemaRest)this.converter.toRest(metadataSchema, this.utils.obtainProjection());
    }
}

