/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.converter.MetadataConverter;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.patch.ResourcePatch;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;

public abstract class DSpaceObjectRestRepository<M extends DSpaceObject, R extends DSpaceObjectRest>
extends DSpaceRestRepository<R, UUID> {
    final DSpaceObjectService<M> dsoService;
    @Autowired
    ResourcePatch<M> resourcePatch;
    @Autowired
    MetadataConverter metadataConverter;

    DSpaceObjectRestRepository(DSpaceObjectService<M> dsoService) {
        this.dsoService = dsoService;
    }

    protected void patchDSpaceObject(String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, ResourceNotFoundException, SQLException, UnprocessableEntityException {
        Context context = this.obtainContext();
        DSpaceObject dso = this.dsoService.find(context, id);
        if (dso == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + id + " not found");
        }
        this.resourcePatch.patch(this.obtainContext(), dso, patch.getOperations());
        this.dsoService.update(this.obtainContext(), dso);
    }
}

