/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link.process;

import java.util.LinkedList;
import org.dspace.app.rest.RestResourceController;
import org.dspace.app.rest.link.HalLinkFactory;
import org.dspace.app.rest.model.ProcessRest;
import org.dspace.app.rest.model.hateoas.ProcessResource;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.stereotype.Component;

@Component
public class ProcessResourceHalLinkFactory
extends HalLinkFactory<ProcessResource, RestResourceController> {
    @Autowired
    private ConfigurationService configurationService;

    @Override
    protected void addLinks(ProcessResource halResource, Pageable pageable, LinkedList<Link> list) throws Exception {
        String dspaceRestUrl = this.configurationService.getProperty("dspace.server.url");
        list.add(this.buildLink("script", dspaceRestUrl + "/api/system/scripts/" + ((ProcessRest)halResource.getContent()).getScriptName()));
    }

    @Override
    protected Class<RestResourceController> getControllerClass() {
        return RestResourceController.class;
    }

    @Override
    protected Class<ProcessResource> getResourceClass() {
        return ProcessResource.class;
    }
}

