/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link;

import java.util.LinkedList;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.RootRestResourceController;
import org.dspace.app.rest.link.HalLinkFactory;
import org.dspace.app.rest.model.RootRest;
import org.dspace.app.rest.model.hateoas.RootResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.stereotype.Component;

@Component
public class RootHalLinkFactory
extends HalLinkFactory<RootResource, RootRestResourceController> {
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;

    @Override
    protected void addLinks(RootResource halResource, Pageable page, LinkedList<Link> list) throws Exception {
        for (Link endpointLink : this.discoverableEndpointsService.getDiscoverableEndpoints()) {
            list.add(this.buildLink(endpointLink.getRel(), ((RootRest)halResource.getContent()).getDspaceRest() + endpointLink.getHref()));
        }
    }

    @Override
    protected Class<RootRestResourceController> getControllerClass() {
        return RootRestResourceController.class;
    }

    @Override
    protected Class<RootResource> getResourceClass() {
        return RootResource.class;
    }
}

