/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.cli.Option;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.ParameterRest;
import org.dspace.app.rest.model.ScriptRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.scripts.DSpaceRunnable;
import org.springframework.stereotype.Component;

@Component
public class ScriptConverter
implements DSpaceConverter<DSpaceRunnable, ScriptRest> {
    @Override
    public ScriptRest convert(DSpaceRunnable script, Projection projection) {
        ScriptRest scriptRest = new ScriptRest();
        scriptRest.setProjection(projection);
        scriptRest.setDescription(script.getDescription());
        scriptRest.setId(script.getName());
        scriptRest.setName(script.getName());
        LinkedList<ParameterRest> parameterRestList = new LinkedList<ParameterRest>();
        for (Option option : CollectionUtils.emptyIfNull((Collection)script.getOptions().getOptions())) {
            ParameterRest parameterRest = new ParameterRest();
            parameterRest.setDescription(option.getDescription());
            parameterRest.setName(option.getOpt() != null ? "-" + option.getOpt() : "--" + option.getLongOpt());
            parameterRest.setType(((Class)option.getType()).getSimpleName());
            parameterRestList.add(parameterRest);
        }
        scriptRest.setParameterRestList(parameterRestList);
        return scriptRest;
    }

    @Override
    public Class<DSpaceRunnable> getModelClass() {
        return DSpaceRunnable.class;
    }
}

