/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueList;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.DSpaceObject;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DSpaceObjectConverter<M extends DSpaceObject, R extends DSpaceObjectRest>
implements DSpaceConverter<M, R> {
    @Autowired
    ConverterService converter;

    @Override
    public R convert(M obj, Projection projection) {
        R resource = this.newInstance();
        ((RestAddressableModel)resource).setProjection(projection);
        ((DSpaceObjectRest)resource).setHandle(obj.getHandle());
        if (obj.getID() != null) {
            ((DSpaceObjectRest)resource).setUuid(obj.getID().toString());
        }
        ((DSpaceObjectRest)resource).setName(obj.getName());
        MetadataValueList metadataValues = new MetadataValueList(obj.getMetadata());
        ((DSpaceObjectRest)resource).setMetadata((MetadataRest)this.converter.toRest(metadataValues, projection));
        return resource;
    }

    protected abstract R newInstance();
}

