/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.link.HalLinkService;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.utils.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Resource;
import org.springframework.stereotype.Service;

@Service
public class ConverterService {
    private static final Logger log = Logger.getLogger(ConverterService.class);
    private final Map<String, Projection> projectionMap = new HashMap<String, Projection>();
    private final Map<Class, DSpaceConverter> converterMap = new HashMap<Class, DSpaceConverter>();
    private final Map<Class<? extends RestModel>, Constructor> resourceConstructors = new HashMap<Class<? extends RestModel>, Constructor>();
    @Autowired
    private Utils utils;
    @Autowired
    private HalLinkService halLinkService;
    @Autowired
    private List<DSpaceConverter> converters;
    @Autowired
    private List<Projection> projections;

    public <M, R> R toRest(M modelObject, Projection projection) {
        M transformedModel = projection.transformModel(modelObject);
        DSpaceConverter converter = this.requireConverter(modelObject.getClass());
        Object restObject = converter.convert(transformedModel, projection);
        if (restObject instanceof RestModel) {
            return (R)projection.transformRest((RestModel)restObject);
        }
        return restObject;
    }

    public <M, R> Page<R> toRestPage(List<M> modelObjects, Pageable pageable, long total, Projection projection) {
        return new PageImpl(modelObjects, pageable, total).map(object -> this.toRest(object, projection));
    }

    public <M, R> Page<R> toRestPage(Page<M> modelObjects, Projection projection) {
        return modelObjects.map(object -> this.toRest(object, projection));
    }

    <M, R> DSpaceConverter<M, R> getConverter(Class<M> sourceClass) {
        return this.requireConverter(sourceClass);
    }

    public <T extends HALResource> T toResource(RestModel restObject) {
        T halResource = this.getResource(restObject);
        if (restObject instanceof RestAddressableModel) {
            this.utils.embedOrLinkClassLevelRels((HALResource<RestAddressableModel>)((Object)halResource));
            this.halLinkService.addLinks((HALResource)((Object)halResource));
            Projection projection = ((RestAddressableModel)restObject).getProjection();
            return projection.transformResource(halResource);
        }
        this.halLinkService.addLinks((HALResource)((Object)halResource));
        return halResource;
    }

    public Projection getProjection(@Nullable String projectionName) {
        return projectionName == null ? Projection.DEFAULT : this.requireProjection(projectionName);
    }

    private <T extends HALResource> T getResource(RestModel restObject) {
        Constructor constructor = this.resourceConstructors.get(restObject.getClass());
        if (constructor == null) {
            throw new IllegalArgumentException("No constructor found to get resource class from " + restObject);
        }
        try {
            if (constructor.getParameterCount() == 2) {
                return (T)((Object)((HALResource)((Object)constructor.newInstance(restObject, this.utils))));
            }
            return (T)((Object)((HALResource)((Object)constructor.newInstance(restObject))));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Projection requireProjection(String projectionName) {
        if (!this.projectionMap.containsKey(projectionName)) {
            throw new IllegalArgumentException("No such projection: " + projectionName);
        }
        return this.projectionMap.get(projectionName);
    }

    private DSpaceConverter requireConverter(Class sourceClass) {
        if (this.converterMap.containsKey(sourceClass)) {
            return this.converterMap.get(sourceClass);
        }
        for (Class converterSourceClass : this.converterMap.keySet()) {
            if (!converterSourceClass.isAssignableFrom(sourceClass)) continue;
            return this.converterMap.get(converterSourceClass);
        }
        throw new IllegalArgumentException("No converter found to get rest class from " + sourceClass);
    }

    @PostConstruct
    private void initialize() {
        for (Projection projection : this.projections) {
            this.projectionMap.put(projection.getName(), projection);
        }
        this.projectionMap.put(Projection.DEFAULT.getName(), Projection.DEFAULT);
        for (DSpaceConverter converter : this.converters) {
            this.converterMap.put(converter.getModelClass(), converter);
        }
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Resource.class));
        Set beanDefinitions = provider.findCandidateComponents(HALResource.class.getPackage().getName().replaceAll("\\.", "/"));
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String resourceClassName = beanDefinition.getBeanClassName();
            String resourceClassSimpleName = resourceClassName.substring(resourceClassName.lastIndexOf(".") + 1);
            String restClassSimpleName = resourceClassSimpleName.replaceAll("ResourceWrapper$", "RestWrapper").replaceAll("Resource$", "Rest");
            String restClassName = RestModel.class.getPackage().getName() + "." + restClassSimpleName;
            try {
                Class<?> restClass = Class.forName(restClassName);
                Class<?> resourceClass = Class.forName(resourceClassName);
                Constructor<?> compatibleConstructor = null;
                for (Constructor<?> constructor : resourceClass.getDeclaredConstructors()) {
                    if (constructor.getParameterCount() == 2 && constructor.getParameterTypes()[1] == Utils.class) {
                        compatibleConstructor = constructor;
                        break;
                    }
                    if (constructor.getParameterCount() != 1) continue;
                    compatibleConstructor = constructor;
                }
                if (compatibleConstructor != null) {
                    this.resourceConstructors.put(restClass, compatibleConstructor);
                    continue;
                }
                log.warn((Object)("Skipping registration of resource class " + resourceClassName + "; compatible constructor not found"));
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)("Skipping registration of resource class " + resourceClassName + "; rest class not found: " + restClassName));
            }
        }
    }
}

