/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.Arrays;
import java.util.UUID;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.link.HalLinkService;
import org.dspace.app.rest.model.StatisticsSupportRest;
import org.dspace.app.rest.model.hateoas.SearchEventResource;
import org.dspace.app.rest.model.hateoas.StatisticsSupportResource;
import org.dspace.app.rest.model.hateoas.ViewEventResource;
import org.dspace.app.rest.repository.SearchEventRestRepository;
import org.dspace.app.rest.repository.StatisticsRestRepository;
import org.dspace.app.rest.repository.ViewEventRestRepository;
import org.dspace.app.rest.utils.Utils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/statistics"})
public class StatisticsRestController
implements InitializingBean {
    @Autowired
    private Utils utils;
    @Autowired
    private DiscoverableEndpointsService discoverableEndpointsService;
    @Autowired
    private HalLinkService halLinkService;
    @Autowired
    private ConverterService converter;
    @Autowired
    private StatisticsRestRepository statisticsRestRepository;
    @Autowired
    private ViewEventRestRepository viewEventRestRepository;
    @Autowired
    private SearchEventRestRepository searchEventRestRepository;

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register(this, Arrays.asList(new Link("/api/statistics", "statistics")));
    }

    @RequestMapping(method={RequestMethod.GET})
    public StatisticsSupportResource getStatisticsSupport() throws Exception {
        StatisticsSupportRest statisticsSupportRest = this.statisticsRestRepository.getStatisticsSupport();
        return (StatisticsSupportResource)((Object)this.converter.toResource(statisticsSupportRest));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/viewevents/{uuid}"})
    public PagedResources<ViewEventResource> getViewEvent(@PathVariable(name="uuid") UUID uuid) throws Exception {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/searchevents/{uuid}"})
    public PagedResources<SearchEventResource> getSearchEvent(@PathVariable(name="uuid") UUID uuid) throws Exception {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/viewevents"})
    public PagedResources<ViewEventResource> getViewEvents() throws Exception {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/searchevents"})
    public PagedResources<SearchEventResource> getSearchEvents() throws Exception {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/viewevents"})
    public ResponseEntity<ResourceSupport> postViewEvent() throws Exception {
        ViewEventResource result = (ViewEventResource)((Object)this.converter.toResource(this.viewEventRestRepository.createViewEvent()));
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (ResourceSupport)result);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/searchevents"})
    public ResponseEntity<ResourceSupport> postSearchEvent() throws Exception {
        SearchEventResource result = (SearchEventResource)((Object)this.converter.toResource(this.searchEventRestRepository.createSearchEvent()));
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (ResourceSupport)result);
    }
}

