/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.ProcessRest;
import org.dspace.app.rest.model.hateoas.ProcessResource;
import org.dspace.app.rest.repository.ScriptRestRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/system/scripts/{name}/processes"})
public class ScriptProcessesController {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private ConverterService converter;
    @Autowired
    private ScriptRestRepository scriptRestRepository;

    @RequestMapping(method={RequestMethod.POST})
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public ResponseEntity<ResourceSupport> startProcess(@PathVariable(name="name") String scriptName) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Starting Process for Script with name: " + scriptName);
        }
        ProcessRest processRest = this.scriptRestRepository.startProcess(scriptName);
        ProcessResource processResource = (ProcessResource)((Object)this.converter.toResource(processRest));
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.ACCEPTED, (HttpHeaders)new HttpHeaders(), (ResourceSupport)processResource);
    }
}

