/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.sql.SQLException;
import java.util.Arrays;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.EPersonConverter;
import org.dspace.app.rest.link.HalLinkService;
import org.dspace.app.rest.model.AuthenticationStatusRest;
import org.dspace.app.rest.model.AuthnRest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.hateoas.AuthenticationStatusResource;
import org.dspace.app.rest.model.hateoas.AuthnResource;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/authn"})
@RestController
public class AuthenticationRestController
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationRestController.class);
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;
    @Autowired
    private ConverterService converter;
    @Autowired
    private EPersonConverter ePersonConverter;
    @Autowired
    private HalLinkService halLinkService;
    @Autowired
    private Utils utils;

    public void afterPropertiesSet() {
        this.discoverableEndpointsService.register(this, Arrays.asList(new Link("/api/authn", "authn")));
    }

    @RequestMapping(method={RequestMethod.GET})
    public AuthnResource authn() {
        AuthnRest authnRest = new AuthnRest();
        authnRest.setProjection(this.utils.obtainProjection());
        return (AuthnResource)((Object)this.converter.toResource(authnRest));
    }

    @RequestMapping(value={"/status"}, method={RequestMethod.GET})
    public AuthenticationStatusResource status(HttpServletRequest request) throws SQLException {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        EPersonRest ePersonRest = null;
        Projection projection = this.utils.obtainProjection();
        if (context.getCurrentUser() != null) {
            ePersonRest = (EPersonRest)this.converter.toRest(context.getCurrentUser(), projection);
        }
        AuthenticationStatusRest authenticationStatusRest = new AuthenticationStatusRest(ePersonRest);
        authenticationStatusRest.setProjection(projection);
        AuthenticationStatusResource authenticationStatusResource = (AuthenticationStatusResource)((Object)this.converter.toResource(authenticationStatusRest));
        return authenticationStatusResource;
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public ResponseEntity login(HttpServletRequest request, @RequestParam(name="user", required=false) String user, @RequestParam(name="password", required=false) String password) {
        return this.getLoginResponse(request, "Authentication failed for user " + user + ": The credentials you provided are not valid.");
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.GET, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE})
    public ResponseEntity login() {
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).body((Object)"Only POST is allowed for login requests.");
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity logout() {
        return ResponseEntity.noContent().build();
    }

    protected ResponseEntity getLoginResponse(HttpServletRequest request, String failedMessage) {
        Context context = null;
        context = ContextUtil.obtainContext((ServletRequest)request);
        if (context == null || context.getCurrentUser() == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)failedMessage);
        }
        return ResponseEntity.ok().build();
    }
}

