/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.processingaction.ProcessingAction;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class ReviewAction
extends ProcessingAction {
    public static final int MAIN_PAGE = 0;
    public static final int REJECT_PAGE = 1;
    private static final String SUBMIT_APPROVE = "submit_approve";
    private static final String SUBMIT_REJECT = "submit_reject";
    private static final String SUBMITTER_IS_DELETED_PAGE = "submitter_deleted";

    @Override
    public void activate(Context c, XmlWorkflowItem wfItem) {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        if (super.isOptionInParam(request)) {
            switch (Util.getSubmitButton(request, "submit_cancel")) {
                case "submit_approve": {
                    return this.processAccept(c, wfi);
                }
                case "submit_reject": {
                    return this.processRejectPage(c, wfi, step, request);
                }
                case "submitter_deleted": {
                    return this.processSubmitterIsDeletedPage(c, wfi, request);
                }
            }
            return new ActionResult(ActionResult.TYPE.TYPE_CANCEL);
        }
        return new ActionResult(ActionResult.TYPE.TYPE_CANCEL);
    }

    @Override
    public List<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add(SUBMIT_APPROVE);
        options.add(SUBMIT_REJECT);
        return options;
    }

    public ActionResult processAccept(Context c, XmlWorkflowItem wfi) throws SQLException, AuthorizeException {
        this.addApprovedProvenance(c, wfi);
        return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
    }

    private void addApprovedProvenance(Context c, XmlWorkflowItem wfi) throws SQLException, AuthorizeException {
        String now = DCDate.getCurrent().toString();
        String usersName = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().getEPersonName(c.getCurrentUser());
        String provDescription = this.getProvenanceStartId() + " Approved for entry into archive by " + usersName + " on " + now + " (GMT) ";
        this.itemService.addMetadata(c, wfi.getItem(), MetadataSchemaEnum.DC.getName(), "description", "provenance", "en", provDescription);
        this.itemService.update(c, wfi.getItem());
    }

    public ActionResult processRejectPage(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        String reason = request.getParameter("reason");
        if (reason == null || 0 == reason.trim().length()) {
            request.setAttribute("page", (Object)1);
            this.addErrorField(request, "reason");
            return new ActionResult(ActionResult.TYPE.TYPE_ERROR);
        }
        XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().sendWorkflowItemBackSubmission(c, wfi, c.getCurrentUser(), this.getProvenanceStartId(), reason);
        return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
    }

    public ActionResult processSubmitterIsDeletedPage(Context c, XmlWorkflowItem wfi, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        if (request.getParameter("submit_delete") != null) {
            XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().deleteWorkflowByWorkflowItem(c, wfi, c.getCurrentUser());
            return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
        }
        if (request.getParameter("submit_keep_it") != null) {
            return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
        }
        request.setAttribute("page", (Object)0);
        return new ActionResult(ActionResult.TYPE.TYPE_PAGE);
    }
}

