/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.dao.VersionHistoryDAO;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.springframework.beans.factory.annotation.Autowired;

public class VersionHistoryServiceImpl
implements VersionHistoryService {
    @Autowired(required=true)
    protected VersionHistoryDAO versionHistoryDAO;
    @Autowired(required=true)
    private VersioningService versioningService;

    protected VersionHistoryServiceImpl() {
    }

    @Override
    public VersionHistory create(Context context) throws SQLException {
        return this.versionHistoryDAO.create(context, new VersionHistory());
    }

    @Override
    public VersionHistory find(Context context, int id) throws SQLException {
        return (VersionHistory)this.versionHistoryDAO.findByID(context, VersionHistory.class, id);
    }

    @Override
    public void update(Context context, VersionHistory versionHistory) throws SQLException, AuthorizeException {
        this.update(context, Collections.singletonList(versionHistory));
    }

    @Override
    public void update(Context context, List<VersionHistory> versionHistories) throws SQLException, AuthorizeException {
        if (CollectionUtils.isNotEmpty(versionHistories)) {
            for (VersionHistory versionHistory : versionHistories) {
                this.versionHistoryDAO.save(context, versionHistory);
            }
        }
    }

    @Override
    public void delete(Context context, VersionHistory versionHistory) throws SQLException, AuthorizeException {
        this.versionHistoryDAO.delete(context, new VersionHistory());
    }

    @Override
    public Version getPrevious(Context context, VersionHistory versionHistory, Version version) throws SQLException {
        List<Version> versions = this.versioningService.getVersionsByHistory(context, versionHistory);
        int index = versions.indexOf(version);
        if (index + 1 < versions.size()) {
            return versions.get(index + 1);
        }
        return null;
    }

    @Override
    public Version getNext(Context c, VersionHistory versionHistory, Version version) throws SQLException {
        List<Version> versions = this.versioningService.getVersionsByHistory(c, versionHistory);
        int index = versions.indexOf(version);
        if (index - 1 >= 0) {
            return versions.get(index - 1);
        }
        return null;
    }

    @Override
    public Version getVersion(Context context, VersionHistory versionHistory, Item item) throws SQLException {
        Version v = this.versioningService.getVersion(context, item);
        if (v != null) {
            // empty if block
        }
        if (versionHistory.equals(v.getVersionHistory())) {
            return v;
        }
        return null;
    }

    @Override
    public boolean hasNext(Context context, VersionHistory versionHistory, Item item) throws SQLException {
        Version version = this.getVersion(context, versionHistory, item);
        if (version == null) {
            return false;
        }
        return this.hasNext(context, versionHistory, version);
    }

    @Override
    public boolean hasNext(Context context, VersionHistory versionHistory, Version version) throws SQLException {
        return this.getNext(context, versionHistory, version) != null;
    }

    @Override
    public boolean hasVersionHistory(Context context, Item item) throws SQLException {
        return this.findByItem(context, item) != null;
    }

    @Override
    public void add(Context context, VersionHistory versionHistory, Version version) throws SQLException {
        List<Version> versions = versionHistory.getVersions();
        if (versions == null) {
            versions = new ArrayList<Version>();
        }
        versions.add(0, version);
    }

    @Override
    public Version getLatestVersion(Context context, VersionHistory versionHistory) throws SQLException {
        List<Version> versions = this.versioningService.getVersionsByHistory(context, versionHistory);
        if (versions != null && !versions.isEmpty()) {
            return versions.get(0);
        }
        return null;
    }

    @Override
    public Version getFirstVersion(Context context, VersionHistory versionHistory) throws SQLException {
        List<Version> versions = this.versioningService.getVersionsByHistory(context, versionHistory);
        if (versions == null) {
            return null;
        }
        if (versions.size() - 1 >= 0) {
            return versions.get(versions.size() - 1);
        }
        return null;
    }

    @Override
    public boolean isFirstVersion(Context context, Item item) throws SQLException {
        VersionHistory vh = this.findByItem(context, item);
        if (vh == null) {
            return true;
        }
        Version version = this.versioningService.getVersion(context, item);
        return this.isFirstVersion(context, vh, version);
    }

    @Override
    public boolean isFirstVersion(Context context, VersionHistory versionHistory, Version version) throws SQLException {
        return this.getFirstVersion(context, versionHistory).equals(version);
    }

    @Override
    public boolean isLastVersion(Context context, Item item) throws SQLException {
        VersionHistory vh = this.findByItem(context, item);
        if (vh == null) {
            return true;
        }
        Version version = this.versioningService.getVersion(context, item);
        return this.isLastVersion(context, vh, version);
    }

    @Override
    public boolean isLastVersion(Context context, VersionHistory versionHistory, Version version) throws SQLException {
        return this.getLatestVersion(context, versionHistory).equals(version);
    }

    @Override
    public void remove(VersionHistory versionHistory, Version version) {
        List<Version> versions = versionHistory.getVersions();
        versions.remove(version);
    }

    @Override
    public VersionHistory findByItem(Context context, Item item) throws SQLException {
        return this.versionHistoryDAO.findByItem(context, item);
    }
}

