/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.model;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.util.DateMathParser;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessConditionOption {
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    GroupService groupService;
    DateMathParser dateMathParser = new DateMathParser();
    private String name;
    private String groupName;
    private Boolean hasStartDate;
    private Boolean hasEndDate;
    private String startDateLimit;
    private String endDateLimit;

    public String getName() {
        return this.name;
    }

    public void setName(String type) {
        this.name = type;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Boolean getHasStartDate() {
        return this.hasStartDate;
    }

    public void setHasStartDate(Boolean hasStartDate) {
        this.hasStartDate = hasStartDate;
    }

    public Boolean getHasEndDate() {
        return this.hasEndDate;
    }

    public void setHasEndDate(Boolean hasEndDate) {
        this.hasEndDate = hasEndDate;
    }

    public String getStartDateLimit() {
        return this.startDateLimit;
    }

    public void setStartDateLimit(String startDateLimit) {
        this.startDateLimit = startDateLimit;
    }

    public String getEndDateLimit() {
        return this.endDateLimit;
    }

    public void setEndDateLimit(String endDateLimit) {
        this.endDateLimit = endDateLimit;
    }

    public void createResourcePolicy(Context context, Bitstream b, String name, String description, Date startDate, Date endDate) throws SQLException, AuthorizeException, ParseException {
        if (this.getHasStartDate().booleanValue() && startDate == null) {
            throw new IllegalStateException("The access condition " + this.getName() + " requires a start date.");
        }
        if (this.getHasEndDate().booleanValue() && endDate == null) {
            throw new IllegalStateException("The access condition " + this.getName() + " requires an end date.");
        }
        if (!this.getHasStartDate().booleanValue() && startDate != null) {
            throw new IllegalStateException("The access condition " + this.getName() + " cannot contain a start date.");
        }
        if (!this.getHasEndDate().booleanValue() && endDate != null) {
            throw new IllegalStateException("The access condition " + this.getName() + " cannot contain an end date.");
        }
        Date latestStartDate = null;
        if (this.getStartDateLimit() != null) {
            latestStartDate = this.dateMathParser.parseMath(this.getStartDateLimit());
        }
        Date latestEndDate = null;
        if (this.getEndDateLimit() != null) {
            latestEndDate = this.dateMathParser.parseMath(this.getEndDateLimit());
        }
        if (startDate != null && latestStartDate != null && startDate.after(latestStartDate)) {
            throw new IllegalStateException(String.format("The start date of access condition %s should be earlier than %s from now.", this.getName(), this.getStartDateLimit()));
        }
        if (endDate != null && latestEndDate != null && endDate.after(latestEndDate)) {
            throw new IllegalStateException(String.format("The end date of access condition %s should be earlier than %s from now.", this.getName(), this.getEndDateLimit()));
        }
        Group group = this.groupService.findByName(context, this.getGroupName());
        this.authorizeService.createResourcePolicy(context, b, group, null, 0, ResourcePolicy.TYPE_CUSTOM, name, description, startDate, endDate);
    }
}

