/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.dspace.administer.MetadataImporter;
import org.dspace.administer.RegistryImportException;
import org.dspace.administer.RegistryLoader;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class RegistryUpdater
implements Callback {
    private static final Logger log = LoggerFactory.getLogger(RegistryUpdater.class);

    private void updateRegistries() {
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        Context context = null;
        try {
            context = new Context();
            context.turnOffAuthorisationSystem();
            String base = config.getProperty("dspace.dir") + File.separator + "config" + File.separator + "registries" + File.separator;
            log.info("Updating Bitstream Format Registry based on {}bitstream-formats.xml", (Object)base);
            RegistryLoader.loadBitstreamFormats(context, base + "bitstream-formats.xml");
            log.info("Updating Metadata Registries based on metadata type configs in {}", (Object)base);
            for (String namespaceFile : config.getArrayProperty("registry.metadata.load")) {
                log.info("Reading {}", (Object)namespaceFile);
                MetadataImporter.loadRegistry(base + namespaceFile, true);
            }
            String workflowTypes = "workflow-types.xml";
            log.info("Reading {}", (Object)workflowTypes);
            MetadataImporter.loadRegistry(base + workflowTypes, true);
            context.restoreAuthSystemState();
            context.complete();
            log.info("All Bitstream Format Regitry and Metadata Registry updates were completed.");
        }
        catch (IOException | SQLException | ParserConfigurationException | TransformerException | RegistryImportException | AuthorizeException | NonUniqueMetadataException | SAXException e) {
            log.error("Error attempting to update Bitstream Format and/or Metadata Registries", (Throwable)e);
            throw new RuntimeException("Error attempting to update Bitstream Format and/or Metadata Registries", e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    public boolean supports(Event event, org.flywaydb.core.api.callback.Context context) {
        return event.equals((Object)Event.AFTER_MIGRATE);
    }

    public boolean canHandleInTransaction(Event event, org.flywaydb.core.api.callback.Context context) {
        return true;
    }

    public void handle(Event event, org.flywaydb.core.api.callback.Context context) {
        this.updateRegistries();
    }
}

