/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export.processor;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.export.processor.ExportEventProcessor;
import org.dspace.statistics.util.SpiderDetector;

public class BitstreamEventProcessor
extends ExportEventProcessor {
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private Item item;
    private Bitstream bitstream;

    public BitstreamEventProcessor(Context context, HttpServletRequest request, Bitstream bitstream) throws SQLException {
        super(context, request);
        this.bitstream = bitstream;
        this.item = this.getItem(request);
    }

    private Item getItem(HttpServletRequest request) throws SQLException {
        if (0 < this.bitstream.getBundles().size() && !SpiderDetector.isSpider(request)) {
            Bundle bundle = this.bitstream.getBundles().get(0);
            if (bundle.getName() == null || !bundle.getName().equals("ORIGINAL")) {
                return null;
            }
            if (0 < bundle.getItems().size()) {
                Item item = bundle.getItems().get(0);
                return item;
            }
        }
        return null;
    }

    @Override
    public void processEvent() throws SQLException, IOException {
        if (this.shouldProcessItem(this.item)) {
            String baseParam = this.getBaseParameters(this.item);
            String fullParam = this.addObjectSpecificData(baseParam, this.bitstream);
            this.processObject(fullParam);
        }
    }

    protected String addObjectSpecificData(String string, Bitstream bitstream) throws UnsupportedEncodingException {
        StringBuilder data = new StringBuilder(string);
        String bitstreamInfo = this.getBitstreamInfo(bitstream);
        data.append("&").append(URLEncoder.encode("svc_dat", "UTF-8")).append("=").append(URLEncoder.encode(bitstreamInfo, "UTF-8"));
        data.append("&").append(URLEncoder.encode("rft_dat", "UTF-8")).append("=").append(URLEncoder.encode("Request", "UTF-8"));
        return data.toString();
    }

    private String getBitstreamInfo(Bitstream bitstream) {
        String dspaceRestUrl = this.configurationService.getProperty("dspace.server.url");
        StringBuilder sb = new StringBuilder();
        sb.append(dspaceRestUrl);
        sb.append("/api/core/bitstreams/");
        sb.append(bitstream.getID());
        sb.append("/content");
        return sb.toString();
    }
}

