/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.content;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.app.util.Util;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectLegacySupport;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.Dataset;
import org.dspace.statistics.ObjectCount;
import org.dspace.statistics.SolrLoggerServiceImpl;
import org.dspace.statistics.content.DSORepresentation;
import org.dspace.statistics.content.DatasetDSpaceObjectGenerator;
import org.dspace.statistics.content.DatasetGenerator;
import org.dspace.statistics.content.DatasetTimeGenerator;
import org.dspace.statistics.content.DatasetTypeGenerator;
import org.dspace.statistics.content.StatisticsData;
import org.dspace.statistics.content.filter.StatisticsFilter;
import org.dspace.statistics.content.filter.StatisticsSolrDateFilter;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.statistics.service.SolrLoggerService;
import org.dspace.statistics.util.LocationUtils;

public class StatisticsDataVisits
extends StatisticsData {
    protected DSpaceObject currentDso;
    protected final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected final SolrLoggerService solrLoggerService = StatisticsServiceFactory.getInstance().getSolrLoggerService();
    protected final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public StatisticsDataVisits() {
    }

    public StatisticsDataVisits(DSpaceObject dso) {
        this.currentDso = dso;
    }

    public StatisticsDataVisits(DSpaceObject currentDso, Dataset dataset) {
        super(dataset);
        this.currentDso = currentDso;
    }

    public StatisticsDataVisits(Dataset dataset) {
        super(dataset);
    }

    @Override
    public Dataset createDataset(Context context, int facetMinCount) throws SQLException, SolrServerException, ParseException, IOException {
        StatisticsSolrDateFilter dateFilter;
        if (this.getDataset() != null) {
            return this.getDataset();
        }
        ArrayList<DatasetQuery> datasetQueries = new ArrayList<DatasetQuery>();
        for (int i = 0; i < this.getDatasetGenerators().size(); ++i) {
            DatasetGenerator dataSet = this.getDatasetGenerators().get(i);
            this.processAxis(context, dataSet, datasetQueries);
        }
        DatasetTimeGenerator dateFacet = null;
        if (this.getDatasetGenerators().get(0) instanceof DatasetTimeGenerator || 1 < this.getDatasetGenerators().size() && this.getDatasetGenerators().get(1) instanceof DatasetTimeGenerator) {
            dateFacet = this.getDatasetGenerators().get(0) instanceof DatasetTimeGenerator ? (DatasetTimeGenerator)this.getDatasetGenerators().get(0) : (DatasetTimeGenerator)this.getDatasetGenerators().get(1);
        }
        boolean showTotal = false;
        if (this.getDatasetGenerators().get(0) != null && this.getDatasetGenerators().get(0).isIncludeTotal() || 1 < this.getDatasetGenerators().size() && this.getDatasetGenerators().get(1) != null && this.getDatasetGenerators().get(1).isIncludeTotal()) {
            showTotal = true;
        }
        if (dateFacet != null && dateFacet.getActualStartDate() != null && dateFacet.getActualEndDate() != null) {
            dateFilter = new StatisticsSolrDateFilter();
            dateFilter.setStartDate(dateFacet.getActualStartDate());
            dateFilter.setEndDate(dateFacet.getActualEndDate());
            dateFilter.setTypeStr(dateFacet.getDateType());
            this.addFilters(dateFilter);
        } else if (dateFacet != null && dateFacet.getStartDate() != null && dateFacet.getEndDate() != null) {
            dateFilter = new StatisticsSolrDateFilter();
            dateFilter.setStartStr(dateFacet.getStartDate());
            dateFilter.setEndStr(dateFacet.getEndDate());
            dateFilter.setTypeStr(dateFacet.getDateType());
            this.addFilters(dateFilter);
        }
        Object filterQuery = "";
        for (int i = 0; i < this.getFilters().size(); ++i) {
            StatisticsFilter filter = this.getFilters().get(i);
            filterQuery = (String)filterQuery + "(" + filter.toQuery() + ")";
            if (i == this.getFilters().size() - 1) continue;
            filterQuery = (String)filterQuery + " AND ";
        }
        if (StringUtils.isNotBlank((CharSequence)filterQuery)) {
            filterQuery = (String)filterQuery + " AND ";
        }
        filterQuery = (String)filterQuery + "-(statistics_type:[* TO *] AND -statistics_type:" + SolrLoggerServiceImpl.StatisticsType.VIEW.text() + ")";
        Dataset dataset = null;
        if (dateFacet != null) {
            for (int i = 0; i < datasetQueries.size(); ++i) {
                int j;
                DatasetQuery dataSetQuery = datasetQueries.get(i);
                if (dataSetQuery.getQueries().size() != 1) continue;
                String query = dataSetQuery.getQueries().get(0).getQuery();
                if (dataSetQuery.getMax() == -1) {
                    ObjectCount[] results = this.solrLoggerService.queryFacetDate(query, (String)filterQuery, dataSetQuery.getMax(), dateFacet.getDateType(), dateFacet.getStartDate(), dateFacet.getEndDate(), showTotal, context, facetMinCount);
                    dataset = new Dataset(1, results.length);
                    for (j = 0; j < results.length; ++j) {
                        dataset.setColLabel(j, results[j].getValue());
                        dataset.addValueToMatrix(0, j, results[j].getCount());
                    }
                    dataset.setRowLabel(0, this.getResultName(dataSetQuery.getName(), dataSetQuery, context));
                    dataset.setRowLabelAttr(0, this.getAttributes(dataSetQuery.getName(), dataSetQuery, context));
                    continue;
                }
                ObjectCount[] maxObjectCounts = this.solrLoggerService.queryFacetField(query, (String)filterQuery, dataSetQuery.getFacetField(), dataSetQuery.getMax(), false, null, facetMinCount);
                for (j = 0; j < maxObjectCounts.length; ++j) {
                    ObjectCount firstCount = maxObjectCounts[j];
                    String newQuery = dataSetQuery.getFacetField() + ": " + ClientUtils.escapeQueryChars((String)firstCount.getValue()) + " AND " + query;
                    ObjectCount[] maxDateFacetCounts = this.solrLoggerService.queryFacetDate(newQuery, (String)filterQuery, dataSetQuery.getMax(), dateFacet.getDateType(), dateFacet.getStartDate(), dateFacet.getEndDate(), showTotal, context, facetMinCount);
                    if (dataset == null) {
                        dataset = new Dataset(maxObjectCounts.length, maxDateFacetCounts.length);
                    }
                    dataset.setRowLabel(j, this.getResultName(firstCount.getValue(), dataSetQuery, context));
                    dataset.setRowLabelAttr(j, this.getAttributes(firstCount.getValue(), dataSetQuery, context));
                    for (int k = 0; k < maxDateFacetCounts.length; ++k) {
                        ObjectCount objectCount = maxDateFacetCounts[k];
                        if (j == 0) {
                            dataset.setColLabel(k, objectCount.getValue());
                        }
                        dataset.addValueToMatrix(j, k, objectCount.getCount());
                    }
                }
                if (dataset == null || this.getDatasetGenerators().get(0) instanceof DatasetTimeGenerator) continue;
                dataset.flipRowCols();
            }
        } else {
            DatasetQuery firsDataset = datasetQueries.get(0);
            ObjectCount[] topCounts1 = null;
            topCounts1 = this.queryFacetField(firsDataset, firsDataset.getQueries().get(0).getQuery(), (String)filterQuery, facetMinCount);
            if (datasetQueries.size() == 2) {
                DatasetQuery secondDataSet = datasetQueries.get(1);
                ObjectCount[] topCounts2 = this.queryFacetField(secondDataSet, secondDataSet.getQueries().get(0).getQuery(), (String)filterQuery, facetMinCount);
                ArrayList<String> facetQueries = new ArrayList<String>();
                for (ObjectCount count2 : topCounts2) {
                    String facetQuery = secondDataSet.getFacetField() + ":" + ClientUtils.escapeQueryChars((String)count2.getValue());
                    if ("id".equals(secondDataSet.getFacetField()) && secondDataSet.getQueries().get(0).getDsoType() != -1) {
                        facetQuery = facetQuery + " AND type:" + secondDataSet.getQueries().get(0).getDsoType();
                    }
                    facetQueries.add(facetQuery);
                }
                for (int i = 0; i < topCounts1.length; ++i) {
                    ObjectCount count1 = topCounts1[i];
                    ObjectCount[] currentResult = new ObjectCount[topCounts2.length];
                    if (dataset == null) {
                        dataset = new Dataset(topCounts2.length, topCounts1.length);
                    }
                    dataset.setColLabel(i, this.getResultName(count1.getValue(), firsDataset, context));
                    dataset.setColLabelAttr(i, this.getAttributes(count1.getValue(), firsDataset, context));
                    String query = firsDataset.getFacetField() + ":" + ClientUtils.escapeQueryChars((String)count1.getValue());
                    if ("id".equals(firsDataset.getFacetField()) && firsDataset.getQueries().get(0).getDsoType() != -1) {
                        query = query + " AND type:" + firsDataset.getQueries().get(0).getDsoType();
                    }
                    Map<String, Integer> facetResult = this.solrLoggerService.queryFacetQuery(query, (String)filterQuery, facetQueries, facetMinCount);
                    for (int j = 0; j < topCounts2.length; ++j) {
                        ObjectCount count2 = topCounts2[j];
                        if (i == 0) {
                            dataset.setRowLabel(j, this.getResultName(count2.getValue(), secondDataSet, context));
                            dataset.setRowLabelAttr(j, this.getAttributes(count2.getValue(), secondDataSet, context));
                        }
                        String facetQuery = secondDataSet.getFacetField() + ":" + ClientUtils.escapeQueryChars((String)count2.getValue());
                        if ("id".equals(secondDataSet.getFacetField()) && secondDataSet.getQueries().get(0).getDsoType() != -1) {
                            facetQuery = facetQuery + " AND type:" + secondDataSet.getQueries().get(0).getDsoType();
                        }
                        dataset.addValueToMatrix(j, i, facetResult.get(facetQuery).intValue());
                    }
                }
            } else {
                dataset = new Dataset(1, topCounts1.length);
                for (int i = 0; i < topCounts1.length; ++i) {
                    ObjectCount count = topCounts1[i];
                    dataset.setColLabel(i, this.getResultName(count.getValue(), firsDataset, context));
                    dataset.setColLabelAttr(i, this.getAttributes(count.getValue(), firsDataset, context));
                    dataset.addValueToMatrix(0, i, count.getCount());
                }
            }
        }
        if (dataset != null) {
            dataset.setRowTitle("Dataset 1");
            dataset.setColTitle("Dataset 2");
        } else {
            dataset = new Dataset(0, 0);
        }
        return dataset;
    }

    protected void processAxis(Context context, DatasetGenerator datasetGenerator, List<DatasetQuery> queries) throws SQLException {
        if (datasetGenerator instanceof DatasetDSpaceObjectGenerator) {
            DatasetDSpaceObjectGenerator dspaceObjAxis = (DatasetDSpaceObjectGenerator)datasetGenerator;
            List<DSORepresentation> dsoRepresentations = dspaceObjAxis.getDsoRepresentations();
            for (int i = 0; i < dsoRepresentations.size(); ++i) {
                Query query;
                DatasetQuery datasetQuery = new DatasetQuery();
                Integer dsoType = dsoRepresentations.get(i).getType();
                boolean separate = dsoRepresentations.get(i).getSeparate();
                Integer dsoLength = dsoRepresentations.get(i).getNameLength();
                if (this.currentDso != null && dsoType.intValue() == this.currentDso.getType()) {
                    query = new Query();
                    query.setDso(this.currentDso, this.currentDso.getType(), dsoLength);
                    datasetQuery.addQuery(query);
                } else {
                    query = new Query();
                    if (this.currentDso != null && separate && dsoType == 0) {
                        Item item = (Item)this.currentDso;
                        for (int j = 0; j < item.getBundles().size(); ++j) {
                            Bundle bundle = item.getBundles().get(j);
                            for (int k = 0; k < bundle.getBitstreams().size(); ++k) {
                                Bitstream bitstream = bundle.getBitstreams().get(k);
                                if (bitstream.getFormat(context).isInternal()) continue;
                                query.setDso(bitstream, bitstream.getType(), dsoLength);
                            }
                        }
                    } else {
                        query.setOwningDso(this.currentDso);
                        query.setDsoLength(dsoLength);
                        String title = "";
                        switch (dsoType) {
                            case 0: {
                                title = "Files";
                                break;
                            }
                            case 2: {
                                title = "Items";
                                break;
                            }
                            case 3: {
                                title = "Collections";
                                break;
                            }
                            case 4: {
                                title = "Communities";
                                break;
                            }
                        }
                        datasetQuery.setName(title);
                        query.setDsoType(dsoType);
                    }
                    datasetQuery.addQuery(query);
                }
                datasetQuery.setFacetField("id");
                datasetQuery.setMax(dsoRepresentations.get(i).getMax());
                queries.add(datasetQuery);
            }
        } else if (datasetGenerator instanceof DatasetTypeGenerator) {
            DatasetTypeGenerator typeAxis = (DatasetTypeGenerator)datasetGenerator;
            DatasetQuery datasetQuery = new DatasetQuery();
            Query query = new Query();
            if (this.currentDso != null) {
                query.setDso(this.currentDso, this.currentDso.getType());
            }
            datasetQuery.addQuery(query);
            datasetQuery.setMax(typeAxis.getMax());
            datasetQuery.setFacetField(typeAxis.getType());
            datasetQuery.setName(typeAxis.getType());
            queries.add(datasetQuery);
        }
    }

    protected String getResultName(String value, DatasetQuery datasetQuery, Context context) throws SQLException {
        if ("continent".equals(datasetQuery.getName())) {
            value = LocationUtils.getContinentName(value, context.getCurrentLocale());
        } else if ("countryCode".equals(datasetQuery.getName())) {
            value = LocationUtils.getCountryName(value, context.getCurrentLocale());
        } else {
            String dsoId;
            Query query = datasetQuery.getQueries().get(0);
            String legacyNote = "";
            int dsoLength = query.getDsoLength();
            try {
                dsoId = UUID.fromString(value).toString();
            }
            catch (Exception e) {
                try {
                    dsoId = String.valueOf(Integer.parseInt(value));
                    legacyNote = "(legacy)";
                }
                catch (NumberFormatException e1) {
                    dsoId = null;
                }
            }
            if (dsoId == null && query.getDso() != null && value == null) {
                dsoId = query.getDso().getID().toString();
            }
            if (dsoId != null && query.getDsoType() != -1) {
                switch (query.getDsoType()) {
                    case 0: {
                        Bitstream bit = (Bitstream)this.bitstreamService.findByIdOrLegacyId(context, dsoId);
                        if (bit == null) break;
                        return bit.getName() + legacyNote;
                    }
                    case 2: {
                        int firstSpace;
                        Item item = (Item)this.itemService.findByIdOrLegacyId(context, dsoId);
                        if (item == null) break;
                        Object name = "untitled";
                        List<MetadataValue> vals = this.itemService.getMetadata(item, "dc", "title", null, "*");
                        if (vals != null && 0 < vals.size()) {
                            name = vals.get(0).getValue();
                        }
                        if (dsoLength != -1 && ((String)name).length() > dsoLength && (firstSpace = ((String)name).indexOf(32, dsoLength)) != -1) {
                            name = ((String)name).substring(0, firstSpace) + " ...";
                        }
                        return (String)name + legacyNote;
                    }
                    case 3: {
                        int firstSpace;
                        Collection coll = (Collection)this.collectionService.findByIdOrLegacyId(context, dsoId);
                        if (coll == null) break;
                        Object name = coll.getName();
                        if (dsoLength != -1 && ((String)name).length() > dsoLength && (firstSpace = ((String)name).indexOf(32, dsoLength)) != -1) {
                            name = ((String)name).substring(0, firstSpace) + " ...";
                        }
                        return (String)name + legacyNote;
                    }
                    case 4: {
                        int firstSpace;
                        Community comm = (Community)this.communityService.findByIdOrLegacyId(context, dsoId);
                        if (comm == null) break;
                        Object name = comm.getName();
                        if (dsoLength != -1 && ((String)name).length() > dsoLength && (firstSpace = ((String)name).indexOf(32, dsoLength)) != -1) {
                            name = ((String)name).substring(0, firstSpace) + " ...";
                        }
                        return (String)name + legacyNote;
                    }
                }
            }
        }
        return value;
    }

    protected Map<String, String> getAttributes(String value, DatasetQuery datasetQuery, Context context) throws SQLException {
        String dsoId;
        HashMap<String, String> attrs = new HashMap<String, String>();
        Query query = datasetQuery.getQueries().get(0);
        try {
            dsoId = UUID.fromString(value).toString();
        }
        catch (Exception e) {
            try {
                dsoId = String.valueOf(Integer.parseInt(value));
            }
            catch (NumberFormatException e1) {
                dsoId = null;
            }
        }
        if (dsoId == null && query.getDso() != null && value == null) {
            dsoId = query.getDso().getID().toString();
        }
        if (dsoId != null && query.dsoType != -1) {
            switch (query.dsoType) {
                case 0: {
                    Bitstream bit = (Bitstream)this.bitstreamService.findByIdOrLegacyId(context, dsoId);
                    if (bit == null) break;
                    DSpaceObject owningItem = null;
                    List<Bundle> bunds = bit.getBundles();
                    if (0 < bunds.size() && 0 < bunds.get(0).getItems().size()) {
                        owningItem = bunds.get(0).getItems().get(0);
                    }
                    String identifier = null;
                    identifier = owningItem != null && owningItem.getHandle() != null ? "handle/" + owningItem.getHandle() : (owningItem != null ? "item/" + owningItem.getID() : "id/" + bit.getID());
                    String url = this.configurationService.getProperty("dspace.ui.url") + "/bitstream/" + identifier + "/";
                    try {
                        if (bit.getName() != null) {
                            url = url + Util.encodeBitstreamName(bit.getName(), "UTF-8");
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    url = url + "?sequence=" + bit.getSequenceID();
                    attrs.put("url", url);
                    break;
                }
                case 2: {
                    Item item = (Item)this.itemService.findByIdOrLegacyId(context, dsoId);
                    if (item == null || item.getHandle() == null) break;
                    attrs.put("url", this.handleService.resolveToURL(context, item.getHandle()));
                    break;
                }
                case 3: {
                    Collection coll = (Collection)this.collectionService.findByIdOrLegacyId(context, dsoId);
                    if (coll == null || coll.getHandle() == null) break;
                    attrs.put("url", this.handleService.resolveToURL(context, coll.getHandle()));
                    break;
                }
                case 4: {
                    Community comm = (Community)this.communityService.findByIdOrLegacyId(context, dsoId);
                    if (comm == null || comm.getHandle() == null) break;
                    attrs.put("url", this.handleService.resolveToURL(context, comm.getHandle()));
                    break;
                }
            }
        }
        return attrs;
    }

    protected ObjectCount[] queryFacetField(DatasetQuery dataset, String query, String filterQuery, int facetMinCount) throws SolrServerException, IOException {
        String facetType = dataset.getFacetField() == null ? "id" : dataset.getFacetField();
        return this.solrLoggerService.queryFacetField(query, filterQuery, facetType, dataset.getMax(), false, null, facetMinCount);
    }

    public class Query {
        private int dsoType = -1;
        private DSpaceObject dso = null;
        private int dsoLength;
        private DSpaceObject owningDso = null;

        public void setOwningDso(DSpaceObject owningDso) {
            this.owningDso = owningDso;
        }

        public void setDso(DSpaceObject dso, int dsoType) {
            this.dso = dso;
            this.dsoType = dsoType;
        }

        public void setDso(DSpaceObject dso, int dsoType, int length) {
            this.dsoType = dsoType;
            this.dso = dso;
        }

        public void setDsoType(int dsoType) {
            this.dsoType = dsoType;
        }

        public int getDsoLength() {
            return this.dsoLength;
        }

        public void setDsoLength(int dsoLength) {
            this.dsoLength = dsoLength;
        }

        public int getDsoType() {
            return this.dsoType;
        }

        public DSpaceObject getDso() {
            return this.dso;
        }

        public String getQuery() {
            Object query = "";
            if (this.dsoType != -1) {
                query = (String)query + "type: " + this.dsoType;
            }
            if (this.dso != null) {
                query = (String)query + (((String)query).equals("") ? "" : " AND ");
                query = this.dso instanceof DSpaceObjectLegacySupport ? (String)query + " (id:" + this.dso.getID() + " OR id:" + ((DSpaceObjectLegacySupport)((Object)this.dso)).getLegacyId() + ")" : (String)query + "id:" + this.dso.getID();
            }
            if (this.owningDso != null && StatisticsDataVisits.this.currentDso != null) {
                query = (String)query + (((String)query).equals("") ? "" : " AND ");
                Object owningStr = "";
                switch (StatisticsDataVisits.this.currentDso.getType()) {
                    case 2: {
                        owningStr = "owningItem";
                        break;
                    }
                    case 3: {
                        owningStr = "owningColl";
                        break;
                    }
                    case 4: {
                        owningStr = "owningComm";
                        break;
                    }
                }
                owningStr = StatisticsDataVisits.this.currentDso instanceof DSpaceObjectLegacySupport ? "(" + (String)owningStr + ":" + StatisticsDataVisits.this.currentDso.getID() + " OR " + (String)owningStr + ":" + ((DSpaceObjectLegacySupport)((Object)StatisticsDataVisits.this.currentDso)).getLegacyId() + ")" : (String)owningStr + ":" + StatisticsDataVisits.this.currentDso.getID();
                query = (String)query + (String)owningStr;
            }
            if (((String)query).equals("")) {
                query = "*:*";
            }
            return query;
        }
    }

    public static class DatasetQuery {
        private String name;
        private int max;
        private String facetField;
        private final List<Query> queries = new ArrayList<Query>();

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public void addQuery(Query q) {
            this.queries.add(q);
        }

        public List<Query> getQueries() {
            return this.queries;
        }

        public String getFacetField() {
            return this.facetField;
        }

        public void setFacetField(String facetField) {
            this.facetField = facetField;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

