/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrStatisticsCore {
    private static Logger log = LogManager.getLogger(SolrStatisticsCore.class);
    protected SolrClient solr = null;
    @Autowired
    private ConfigurationService configurationService;

    public SolrClient getSolr() {
        if (this.solr == null) {
            this.initSolr();
        }
        return this.solr;
    }

    protected void initSolr() {
        String solrService = this.configurationService.getProperty("solr-statistics.server");
        log.info("solr-statistics.server:  {}", (Object)solrService);
        log.info("usage-statistics.dbfile:  {}", (Object)this.configurationService.getProperty("usage-statistics.dbfile"));
        try {
            this.solr = new HttpSolrClient.Builder(solrService).build();
        }
        catch (Exception e) {
            log.error("Error accessing Solr server configured in 'solr-statistics.server'", (Throwable)e);
        }
    }
}

