/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.service.components;

import java.io.InputStream;
import java.util.List;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.exception.FileMultipleOccurencesException;
import org.dspace.importer.external.exception.FileSourceException;
import org.dspace.importer.external.service.components.MetadataSource;

public interface FileSource
extends MetadataSource {
    public List<String> getSupportedExtensions();

    public List<ImportRecord> getRecords(InputStream var1) throws FileSourceException;

    public ImportRecord getRecord(InputStream var1) throws FileSourceException, FileMultipleOccurencesException;

    default public boolean isValidSourceForFile(String originalName) {
        List<String> extensions = this.getSupportedExtensions();
        if (extensions == null || extensions.isEmpty()) {
            return false;
        }
        if (originalName != null && originalName.contains(".")) {
            String extension = originalName.substring(originalName.lastIndexOf(46) + 1, originalName.length());
            return this.getSupportedExtensions().contains(extension);
        }
        return false;
    }
}

