/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping;

import org.dspace.importer.external.metadatamapping.MetadatumDTO;

public class MetadataFieldConfig {
    private String schema;
    private String element;
    private String qualifier;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataFieldConfig that = (MetadataFieldConfig)o;
        if (!this.element.equals(that.element)) {
            return false;
        }
        if (this.qualifier != null ? !this.qualifier.equals(that.qualifier) : that.qualifier != null) {
            return false;
        }
        return this.schema.equals(that.schema);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetadataField");
        sb.append("{schema='").append(this.schema).append('\'');
        sb.append(", element='").append(this.element).append('\'');
        sb.append(", qualifier='").append(this.qualifier).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        int result = this.schema.hashCode();
        result = 31 * result + this.element.hashCode();
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        return result;
    }

    public MetadataFieldConfig(MetadatumDTO value) {
        this.schema = value.getSchema();
        this.element = value.getElement();
        this.qualifier = value.getQualifier();
    }

    public MetadataFieldConfig() {
    }

    public MetadataFieldConfig(String schema, String element, String qualifier) {
        this.schema = schema;
        this.element = element;
        this.qualifier = qualifier;
    }

    public MetadataFieldConfig(String full) {
        String[] elements = full.split("\\.");
        if (elements.length == 2) {
            this.schema = elements[0];
            this.element = elements[1];
        } else if (elements.length == 3) {
            this.schema = elements[0];
            this.element = elements[1];
            this.qualifier = elements[2];
        }
    }

    public MetadataFieldConfig(String schema, String element) {
        this.schema = schema;
        this.element = element;
        this.qualifier = null;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getField() {
        return this.schema + "." + this.element + (String)(this.qualifier == null ? "" : "." + this.qualifier);
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }
}

