/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.health;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.dspace.app.statistics.LogAnalyser;
import org.dspace.core.Context;
import org.dspace.health.Check;
import org.dspace.health.ReportInfo;

public class LogAnalyserCheck
extends Check {
    private static final String[][] interesting_fields = new String[][]{{"exceptions", "Exceptions"}, {"warnings", "Warnings"}, {"action.browse", "Archive browsed"}, {"action.search", "Archive searched"}, {"action.login", "Logged in"}, {"action.oai_request", "OAI requests"}};

    @Override
    public String run(ReportInfo ri) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> info_map = new HashMap<String, String>();
        for (String[] info : interesting_fields) {
            info_map.put(info[0], "unknown");
        }
        try {
            Context c = new Context();
            String report = LogAnalyser.processLogs(c, null, null, null, null, ri.from(), ri.till(), false);
            for (String string : report.split("\\r?\\n")) {
                String[] parts = string.split("=");
                if (parts.length != 2) continue;
                info_map.put(parts[0], parts[1]);
            }
            for (String string : interesting_fields) {
                sb.append(String.format("%-20s: %s\n", string[1], info_map.get(string[0])));
            }
            sb.append(String.format("Items added since [%s] (db): %s\n", new SimpleDateFormat("yyyy-MM-dd").format(ri.from().getTime()), LogAnalyser.getNumItems(c)));
            c.complete();
        }
        catch (Exception e) {
            this.error(e);
        }
        return sb.toString();
    }
}

