/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.util.ContentStreamBase;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.Utils;

public class FullTextContentStreams
extends ContentStreamBase {
    private static final Logger log = LogManager.getLogger(FullTextContentStreams.class);
    public static final String FULLTEXT_BUNDLE = "TEXT";
    protected final Context context;
    protected List<FullTextBitstream> fullTextStreams;
    protected BitstreamService bitstreamService;

    public FullTextContentStreams(Context context, Item parentItem) throws SQLException {
        this.context = context;
        this.init(parentItem);
    }

    protected void init(Item parentItem) {
        this.fullTextStreams = new LinkedList<FullTextBitstream>();
        if (parentItem != null) {
            this.sourceInfo = parentItem.getHandle();
            this.contentType = "text/plain";
            this.buildFullTextList(parentItem);
        }
    }

    private void buildFullTextList(Item parentItem) {
        List<Bundle> myBundles = parentItem.getBundles();
        for (Bundle myBundle : Utils.emptyIfNull(myBundles)) {
            if (!StringUtils.equals((CharSequence)FULLTEXT_BUNDLE, (CharSequence)myBundle.getName())) continue;
            List<Bitstream> bitstreams = myBundle.getBitstreams();
            for (Bitstream fulltextBitstream : Utils.emptyIfNull(bitstreams)) {
                this.fullTextStreams.add(new FullTextBitstream(this.sourceInfo, fulltextBitstream));
                log.debug("Added BitStream: " + fulltextBitstream.getStoreNumber() + " " + fulltextBitstream.getSequenceID() + " " + fulltextBitstream.getName());
            }
        }
    }

    public String getName() {
        return StringUtils.join((Iterable)Iterables.transform(this.fullTextStreams, (Function)new Function<FullTextBitstream, String>(){

            @Nullable
            public String apply(@Nullable FullTextBitstream input) {
                return input == null ? "" : input.getFileName();
            }
        }), (String)";");
    }

    public Long getSize() {
        long result = 0L;
        if (CollectionUtils.isNotEmpty(this.fullTextStreams)) {
            Iterable individualSizes = Iterables.transform(this.fullTextStreams, (Function)new Function<FullTextBitstream, Long>(){

                @Nullable
                public Long apply(@Nullable FullTextBitstream input) {
                    return input == null ? 0L : input.getSize();
                }
            });
            for (Long size : individualSizes) {
                result += size.longValue();
            }
        }
        return result;
    }

    public Reader getReader() throws IOException {
        return super.getReader();
    }

    public InputStream getStream() throws IOException {
        try {
            return new SequenceInputStream(new FullTextEnumeration(this.fullTextStreams.iterator()));
        }
        catch (Exception e) {
            log.error("Unable to add full text bitstreams to SOLR for item " + this.sourceInfo + ": " + e.getMessage(), (Throwable)e);
            return new ByteArrayInputStream((e.getClass() + ": " + e.getMessage()).getBytes(StandardCharsets.UTF_8));
        }
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.fullTextStreams);
    }

    private BitstreamService getBitstreamService() {
        if (this.bitstreamService == null) {
            this.bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
        }
        return this.bitstreamService;
    }

    private class FullTextEnumeration
    implements Enumeration<InputStream> {
        private final Iterator<FullTextBitstream> fulltextIterator;

        public FullTextEnumeration(Iterator<FullTextBitstream> fulltextStreams) {
            this.fulltextIterator = fulltextStreams;
        }

        @Override
        public boolean hasMoreElements() {
            return this.fulltextIterator.hasNext();
        }

        @Override
        public InputStream nextElement() {
            InputStream inputStream = null;
            FullTextBitstream bitstream = null;
            try {
                bitstream = this.fulltextIterator.next();
                inputStream = bitstream.getInputStream();
            }
            catch (Exception e) {
                log.warn("Unable to add full text bitstream " + (String)(bitstream == null ? "NULL" : bitstream.getFileName() + " for item " + bitstream.getItemHandle()) + " to SOLR:" + e.getMessage(), (Throwable)e);
                inputStream = new ByteArrayInputStream((e.getClass() + ": " + e.getMessage()).getBytes(StandardCharsets.UTF_8));
            }
            return inputStream == null ? null : new SequenceInputStream(new ByteArrayInputStream("\n".getBytes(StandardCharsets.UTF_8)), inputStream);
        }
    }

    private class FullTextBitstream {
        private String itemHandle;
        private Bitstream bitstream;

        public FullTextBitstream(String parentHandle, Bitstream file) {
            this.itemHandle = parentHandle;
            this.bitstream = file;
        }

        public String getContentType(Context context) throws SQLException {
            BitstreamFormat format = this.bitstream.getFormat(context);
            return format == null ? null : StringUtils.trimToEmpty((String)format.getMIMEType());
        }

        public String getFileName() {
            return StringUtils.trimToEmpty((String)this.bitstream.getName());
        }

        public long getSize() {
            return this.bitstream.getSizeBytes();
        }

        public InputStream getInputStream() throws SQLException, IOException, AuthorizeException {
            return FullTextContentStreams.this.getBitstreamService().retrieve(FullTextContentStreams.this.context, this.bitstream);
        }

        public String getItemHandle() {
            return this.itemHandle;
        }
    }
}

