/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Verifier;

public class XHTMLHeadDisseminationCrosswalk
extends SelfNamedPlugin
implements DisseminationCrosswalk {
    private static final Logger log = LogManager.getLogger(XHTMLHeadDisseminationCrosswalk.class);
    private static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    protected final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private final String config = this.configurationService.getProperty("dspace.dir") + File.separator + "config" + File.separator + "crosswalks" + File.separator + "xhtml-head-item.properties";
    private Map<String, String> names = new HashMap<String, String>();
    private Map<String, String> schemes = new HashMap<String, String>();
    private Map<String, String> schemaURLs = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XHTMLHeadDisseminationCrosswalk() throws IOException {
        Properties crosswalkProps = new Properties();
        FileInputStream fis = new FileInputStream(this.config);
        try {
            crosswalkProps.load(fis);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        Enumeration<Object> e = crosswalkProps.keys();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            if (prop.startsWith("schema.")) {
                this.schemaURLs.put(prop, crosswalkProps.getProperty(prop));
                continue;
            }
            String[] s = ((String)crosswalkProps.get(prop)).split(",");
            if (s.length == 2) {
                this.schemes.put(prop, s[1]);
            }
            if (s.length == 1 || s.length == 2) {
                this.names.put(prop, s[0]);
                continue;
            }
            log.warn("Malformed parameter " + prop + " in " + this.config);
        }
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 2;
    }

    @Override
    public Element disseminateElement(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Element head = new Element("head", XHTML_NAMESPACE);
        head.addContent(this.disseminateList(context, dso));
        return head;
    }

    @Override
    public List<Element> disseminateList(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            String h = dso.getHandle();
            throw new CrosswalkObjectNotSupported("Can only support items; object passed in with DB ID " + dso.getID() + ", type " + Constants.typeText[dso.getType()] + ", handle " + (h == null ? "null" : h));
        }
        Item item = (Item)dso;
        String handle = item.getHandle();
        ArrayList<Element> metas = new ArrayList<Element>();
        List<MetadataValue> values = this.itemService.getMetadata(item, "*", "*", "*", "*");
        for (String s : this.schemaURLs.keySet()) {
            Element e = new Element("link", XHTML_NAMESPACE);
            e.setAttribute("rel", s);
            e.setAttribute("href", this.schemaURLs.get(s));
            metas.add(e);
        }
        for (int i = 0; i < values.size(); ++i) {
            String schemeAttr;
            boolean provenance;
            String key;
            MetadataValue v = values.get(i);
            MetadataField metadataField = v.getMetadataField();
            MetadataSchema metadataSchema = metadataField.getMetadataSchema();
            String originalKey = key = metadataSchema.getName() + "." + metadataField.getElement() + (String)(metadataField.getQualifier() != null ? "." + metadataField.getQualifier() : "");
            String name = this.names.get(key);
            if (name == null && metadataField.getQualifier() != null) {
                key = metadataSchema.getName() + "." + metadataField.getElement();
                name = this.names.get(key);
            }
            boolean bl = provenance = "description".equals(metadataField.getElement()) && "provenance".equals(metadataField.getQualifier());
            if (name == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("No <meta> field for item " + (handle == null ? String.valueOf(dso.getID()) : handle) + " field " + originalKey);
                continue;
            }
            if (provenance) continue;
            Element e = new Element("meta", XHTML_NAMESPACE);
            e.setAttribute("name", name);
            if (v.getValue() == null) {
                e.setAttribute("content", "");
            } else {
                String reason = Verifier.checkCharacterData((String)v.getValue());
                if (reason == null) {
                    e.setAttribute("content", v.getValue());
                } else {
                    log.warn("Invalid attribute characters in Metadata: " + reason);
                    String simpleText = v.getValue().replaceAll("\\p{Cntrl}", "");
                    if (Verifier.checkCharacterData((String)simpleText) == null) {
                        e.setAttribute("content", simpleText);
                    }
                }
            }
            if (v.getLanguage() != null && !v.getLanguage().equals("")) {
                e.setAttribute("lang", v.getLanguage(), Namespace.XML_NAMESPACE);
            }
            if ((schemeAttr = this.schemes.get(key)) != null) {
                e.setAttribute("scheme", schemeAttr);
            }
            metas.add(e);
        }
        return metas;
    }

    @Override
    public Namespace[] getNamespaces() {
        return new Namespace[]{Namespace.getNamespace((String)XHTML_NAMESPACE)};
    }

    @Override
    public String getSchemaLocation() {
        return "";
    }

    @Override
    public boolean preferList() {
        return true;
    }

    public static String[] getPluginNames() {
        return new String[]{"XHTML_HEAD_ITEM"};
    }
}

