/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.crosswalk.XSLTCrosswalk;
import org.dspace.content.crosswalk.XSLTDisseminationCrosswalk;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.packager.DSpaceAIPIngester;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom.Element;
import org.jdom.Namespace;

public class AIPTechMDCrosswalk
implements IngestionCrosswalk,
DisseminationCrosswalk {
    private static final Logger log = LogManager.getLogger(AIPTechMDCrosswalk.class);
    protected final BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected final SiteService siteService = ContentServiceFactory.getInstance().getSiteService();
    protected final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected final EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Override
    public Namespace[] getNamespaces() {
        Namespace[] result = new Namespace[]{XSLTCrosswalk.DIM_NS};
        return result;
    }

    @Override
    public String getSchemaLocation() {
        return "";
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 5 || dso.getType() == 4 || dso.getType() == 3 || dso.getType() == 2 || dso.getType() == 0;
    }

    @Override
    public boolean preferList() {
        return false;
    }

    @Override
    public List<Element> disseminateList(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Element dim = this.disseminateElement(context, dso);
        return dim.getChildren();
    }

    @Override
    public Element disseminateElement(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        ArrayList<MetadataValueDTO> dc = new ArrayList<MetadataValueDTO>();
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            EPerson is = item.getSubmitter();
            if (is != null) {
                dc.add(AIPTechMDCrosswalk.makeDC("creator", null, is.getEmail()));
            }
            dc.add(AIPTechMDCrosswalk.makeDC("identifier", "uri", "hdl:" + item.getHandle()));
            Collection owningColl = item.getOwningCollection();
            String owner = owningColl.getHandle();
            if (owner != null) {
                dc.add(AIPTechMDCrosswalk.makeDC("relation", "isPartOf", "hdl:" + owner));
            }
            List<Collection> inColl = item.getCollections();
            for (int i = 0; i < inColl.size(); ++i) {
                String h;
                if (inColl.get(i).getID().equals(owningColl.getID()) || (h = inColl.get(i).getHandle()) == null) continue;
                dc.add(AIPTechMDCrosswalk.makeDC("relation", "isReferencedBy", "hdl:" + h));
            }
            if (item.isWithdrawn()) {
                dc.add(AIPTechMDCrosswalk.makeDC("rights", "accessRights", "WITHDRAWN"));
            }
        } else if (dso.getType() == 0) {
            String bsUfmt;
            String bsDesc;
            String bsSource;
            Bitstream bitstream = (Bitstream)dso;
            String bsName = bitstream.getName();
            if (bsName != null) {
                dc.add(AIPTechMDCrosswalk.makeDC("title", null, bsName));
            }
            if ((bsSource = bitstream.getSource()) != null) {
                dc.add(AIPTechMDCrosswalk.makeDC("title", "alternative", bsSource));
            }
            if ((bsDesc = bitstream.getDescription()) != null) {
                dc.add(AIPTechMDCrosswalk.makeDC("description", null, bsDesc));
            }
            if ((bsUfmt = bitstream.getUserFormatDescription()) != null) {
                dc.add(AIPTechMDCrosswalk.makeDC("format", null, bsUfmt));
            }
            BitstreamFormat bsf = bitstream.getFormat(context);
            dc.add(AIPTechMDCrosswalk.makeDC("format", "medium", bsf.getShortDescription()));
            dc.add(AIPTechMDCrosswalk.makeDC("format", "mimetype", bsf.getMIMEType()));
            dc.add(AIPTechMDCrosswalk.makeDC("format", "supportlevel", this.bitstreamFormatService.getSupportLevelText(bsf)));
            dc.add(AIPTechMDCrosswalk.makeDC("format", "internal", Boolean.toString(bsf.isInternal())));
        } else if (dso.getType() == 3) {
            Collection collection = (Collection)dso;
            dc.add(AIPTechMDCrosswalk.makeDC("identifier", "uri", "hdl:" + dso.getHandle()));
            List<Community> owners = collection.getCommunities();
            String ownerHdl = owners.get(0).getHandle();
            if (ownerHdl != null) {
                dc.add(AIPTechMDCrosswalk.makeDC("relation", "isPartOf", "hdl:" + ownerHdl));
            }
            for (int i = 1; i < owners.size(); ++i) {
                String h = owners.get(i).getHandle();
                if (h == null) continue;
                dc.add(AIPTechMDCrosswalk.makeDC("relation", "isReferencedBy", "hdl:" + h));
            }
        } else if (dso.getType() == 4) {
            Community community = (Community)dso;
            dc.add(AIPTechMDCrosswalk.makeDC("identifier", "uri", "hdl:" + dso.getHandle()));
            List<Community> parentCommunities = community.getParentCommunities();
            String ownerHdl = null;
            ownerHdl = CollectionUtils.isEmpty(parentCommunities) ? this.siteService.findSite(context).getHandle() : parentCommunities.get(0).getHandle();
            if (ownerHdl != null) {
                dc.add(AIPTechMDCrosswalk.makeDC("relation", "isPartOf", "hdl:" + ownerHdl));
            }
        } else if (dso.getType() == 5) {
            Site site = (Site)dso;
            dc.add(AIPTechMDCrosswalk.makeDC("identifier", "uri", "hdl:" + site.getHandle()));
            dc.add(AIPTechMDCrosswalk.makeDC("identifier", "uri", site.getURL()));
        }
        return XSLTDisseminationCrosswalk.createDIM(dso, dc);
    }

    private static MetadataValueDTO makeDC(String element, String qualifier, String value) {
        MetadataValueDTO dcv = new MetadataValueDTO();
        dcv.setSchema("dc");
        dcv.setLanguage(null);
        dcv.setElement(element);
        dcv.setQualifier(qualifier);
        dcv.setValue(value);
        return dcv;
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, Element root, boolean createMissingMetadataFields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        this.ingest(context, dso, root.getChildren(), createMissingMetadataFields);
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, List<Element> dimList, boolean createMissingMetadataFields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        int type = dso.getType();
        String bsfShortName = null;
        String bsfMIMEType = null;
        int bsfSupport = 1;
        boolean bsfInternal = false;
        for (Element field : dimList) {
            if (field.getName().equals("dim") && field.getNamespace().equals((Object)XSLTCrosswalk.DIM_NS)) {
                this.ingest(context, dso, field.getChildren(), createMissingMetadataFields);
                continue;
            }
            if (field.getName().equals("field") && field.getNamespace().equals((Object)XSLTCrosswalk.DIM_NS)) {
                String schema = field.getAttributeValue("mdschema");
                if (schema.equals("dc")) {
                    Object dcField = field.getAttributeValue("element");
                    String qualifier = field.getAttributeValue("qualifier");
                    if (qualifier != null) {
                        dcField = (String)dcField + "." + qualifier;
                    }
                    String value = field.getText();
                    if (type == 0) {
                        Bitstream bitstream = (Bitstream)dso;
                        if (((String)dcField).equals("title")) {
                            bitstream.setName(context, value);
                            continue;
                        }
                        if (((String)dcField).equals("title.alternative")) {
                            bitstream.setSource(context, value);
                            continue;
                        }
                        if (((String)dcField).equals("description")) {
                            bitstream.setDescription(context, value);
                            continue;
                        }
                        if (((String)dcField).equals("format")) {
                            bitstream.setUserFormatDescription(context, value);
                            continue;
                        }
                        if (((String)dcField).equals("format.medium")) {
                            bsfShortName = value;
                            continue;
                        }
                        if (((String)dcField).equals("format.mimetype")) {
                            bsfMIMEType = value;
                            continue;
                        }
                        if (((String)dcField).equals("format.supportlevel")) {
                            int sl = this.bitstreamFormatService.getSupportLevelID(value);
                            if (sl < 0) {
                                throw new MetadataValidationException("Got unrecognized value for bitstream support level: " + value);
                            }
                            bsfSupport = sl;
                            continue;
                        }
                        if (((String)dcField).equals("format.internal")) {
                            bsfInternal = Boolean.valueOf(value);
                            continue;
                        }
                        log.warn("Got unrecognized DC field for Bitstream: " + (String)dcField);
                        continue;
                    }
                    if (type == 2) {
                        Item item = (Item)dso;
                        if (((String)dcField).equals("creator")) {
                            EPerson sub = this.ePersonService.findByEmail(context, value);
                            if (sub == null) {
                                String configName = new DSpaceAIPIngester().getConfigurationName();
                                if (this.configurationService.getBooleanProperty("mets." + configName + ".ingest.createSubmitter")) {
                                    sub = this.ePersonService.create(context);
                                    sub.setEmail(value);
                                    sub.setCanLogIn(false);
                                    this.ePersonService.update(context, sub);
                                } else {
                                    log.warn("Ignoring unknown Submitter=" + value + " in AIP Tech MD, no matching EPerson and 'mets.dspaceAIP.ingest.createSubmitter' is false in dspace.cfg.");
                                }
                            }
                            if (sub == null) continue;
                            item.setSubmitter(sub);
                            continue;
                        }
                        if (((String)dcField).equals("rights.accessRights")) {
                            if (!value.equalsIgnoreCase("WITHDRAWN")) continue;
                            this.itemService.withdraw(context, item);
                            continue;
                        }
                        if (((String)dcField).equals("identifier.uri") || ((String)dcField).equals("relation.isPartOf")) continue;
                        if (((String)dcField).equals("relation.isReferencedBy")) {
                            Collection collection;
                            DSpaceObject parentDso;
                            String parentHandle = value;
                            if (parentHandle == null || parentHandle.isEmpty()) continue;
                            if (parentHandle.startsWith("hdl:")) {
                                parentHandle = parentHandle.substring(4);
                            }
                            if ((parentDso = this.handleService.resolveToObject(context, parentHandle)) == null || parentDso.getType() != 3 || this.itemService.isIn(item, collection = (Collection)parentDso)) continue;
                            this.collectionService.addItem(context, collection, item);
                            continue;
                        }
                        log.warn("Got unrecognized DC field for Item: " + (String)dcField);
                        continue;
                    }
                    if (type != 4 && type != 3 || ((String)dcField).equals("identifier.uri") || ((String)dcField).equals("relation.isPartOf") || ((String)dcField).equals("relation.isReferencedBy")) continue;
                    log.warn("Got unrecognized DC field for Collection/Community: " + (String)dcField);
                    continue;
                }
                log.warn("Skipping DIM field with mdschema=\"" + schema + "\".");
                continue;
            }
            log.error("Got unexpected element in DIM list: " + field.toString());
            throw new MetadataValidationException("Got unexpected element in DIM list: " + field.toString());
        }
        if (type == 0 && bsfShortName != null) {
            BitstreamFormat bsf = this.bitstreamFormatService.findByShortDescription(context, bsfShortName);
            if (bsf == null && bsfMIMEType != null) {
                bsf = PackageUtils.findOrCreateBitstreamFormat(context, bsfShortName, bsfMIMEType, bsfShortName, bsfSupport, bsfInternal);
            }
            if (bsf != null) {
                ((Bitstream)dso).setFormat(context, bsf);
            } else {
                log.warn("Failed to find or create bitstream format named \"" + bsfShortName + "\"");
            }
        }
    }
}

