/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.HierarchicalAuthority;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DSpaceControlledVocabulary
extends SelfNamedPlugin
implements HierarchicalAuthority {
    private static Logger log = LogManager.getLogger(DSpaceControlledVocabulary.class);
    protected static String xpathTemplate = "//node[contains(translate(@label,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz'),'%s')]";
    protected static String idTemplate = "//node[@id = '%s']";
    protected static String labelTemplate = "//node[@label = '%s']";
    protected static String idParentTemplate = "//node[@id = '%s']/parent::isComposedBy/parent::node";
    protected static String rootTemplate = "/node";
    protected static String[] pluginNames = null;
    protected String vocabularyName = null;
    protected InputSource vocabulary = null;
    protected Boolean suggestHierarchy = false;
    protected Boolean storeHierarchy = true;
    protected String hierarchyDelimiter = "::";
    protected Integer preloadLevel = 1;

    @Override
    public boolean storeAuthorityInMetadata() {
        return false;
    }

    public static String[] getPluginNames() {
        if (pluginNames == null) {
            DSpaceControlledVocabulary.initPluginNames();
        }
        return (String[])ArrayUtils.clone((Object[])pluginNames);
    }

    private static synchronized void initPluginNames() {
        if (pluginNames == null) {
            String vocabulariesPath = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + "/config/controlled-vocabularies/";
            class XmlFilter
            implements FilenameFilter {
                XmlFilter() {
                }

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            }
            String[] xmlFiles = new File(vocabulariesPath).list(new XmlFilter());
            ArrayList<String> names = new ArrayList<String>();
            for (String filename : xmlFiles) {
                names.add(new File(filename).getName().replace(".xml", ""));
            }
            pluginNames = names.toArray(new String[names.size()]);
            log.info("Got plugin names = " + Arrays.deepToString(pluginNames));
        }
    }

    protected void init() {
        if (this.vocabulary == null) {
            ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
            log.info("Initializing " + this.getClass().getName());
            this.vocabularyName = this.getPluginInstanceName();
            String vocabulariesPath = config.getProperty("dspace.dir") + "/config/controlled-vocabularies/";
            String configurationPrefix = "vocabulary.plugin." + this.vocabularyName;
            this.storeHierarchy = config.getBooleanProperty(configurationPrefix + ".hierarchy.store", this.storeHierarchy.booleanValue());
            this.suggestHierarchy = config.getBooleanProperty(configurationPrefix + ".hierarchy.suggest", this.suggestHierarchy.booleanValue());
            this.preloadLevel = config.getIntProperty(configurationPrefix + ".hierarchy.preloadLevel", this.preloadLevel.intValue());
            String configuredDelimiter = config.getProperty(configurationPrefix + ".delimiter");
            if (configuredDelimiter != null) {
                this.hierarchyDelimiter = configuredDelimiter.replaceAll("(^\"|\"$)", "");
            }
            String filename = vocabulariesPath + this.vocabularyName + ".xml";
            log.info("Loading " + filename);
            this.vocabulary = new InputSource(filename);
        }
    }

    protected String buildString(Node node) {
        if (node.getNodeType() == 9) {
            return "";
        }
        String parentValue = this.buildString(node.getParentNode());
        Node currentLabel = node.getAttributes().getNamedItem("label");
        if (currentLabel != null) {
            String currentValue = currentLabel.getNodeValue();
            if (parentValue.equals("")) {
                return currentValue;
            }
            return parentValue + this.hierarchyDelimiter + currentValue;
        }
        return parentValue;
    }

    @Override
    public Choices getMatches(String text, int start, int limit, String locale) {
        this.init();
        log.debug("Getting matches for '" + text + "'");
        Object xpathExpression = "";
        String[] textHierarchy = text.split(this.hierarchyDelimiter, -1);
        for (int i = 0; i < textHierarchy.length; ++i) {
            xpathExpression = (String)xpathExpression + String.format(xpathTemplate, textHierarchy[i].replaceAll("'", "&apos;").toLowerCase());
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        int total = 0;
        List<Object> choices = new ArrayList();
        try {
            NodeList results = (NodeList)xpath.evaluate((String)xpathExpression, this.vocabulary, XPathConstants.NODESET);
            total = results.getLength();
            choices = this.getChoicesFromNodeList(results, start, limit);
        }
        catch (XPathExpressionException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new Choices(true);
        }
        return new Choices(choices.toArray(new Choice[choices.size()]), start, total, 400, total > start + limit);
    }

    @Override
    public Choices getBestMatch(String text, String locale) {
        this.init();
        log.debug("Getting best matches for '" + text + "'");
        Object xpathExpression = "";
        String[] textHierarchy = text.split(this.hierarchyDelimiter, -1);
        for (int i = 0; i < textHierarchy.length; ++i) {
            xpathExpression = (String)xpathExpression + String.format(labelTemplate, textHierarchy[i].replaceAll("'", "&apos;"));
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        List<Object> choices = new ArrayList();
        try {
            NodeList results = (NodeList)xpath.evaluate((String)xpathExpression, this.vocabulary, XPathConstants.NODESET);
            choices = this.getChoicesFromNodeList(results, 0, 1);
        }
        catch (XPathExpressionException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new Choices(true);
        }
        return new Choices(choices.toArray(new Choice[choices.size()]), 0, choices.size(), 400, false);
    }

    @Override
    public String getLabel(String key, String locale) {
        return this.getNodeLabel(key, this.suggestHierarchy);
    }

    @Override
    public String getValue(String key, String locale) {
        return this.getNodeLabel(key, this.storeHierarchy);
    }

    @Override
    public Choice getChoice(String authKey, String locale) {
        Node node;
        try {
            node = this.getNode(authKey);
        }
        catch (XPathExpressionException e) {
            return null;
        }
        return this.createChoiceFromNode(node);
    }

    @Override
    public boolean isHierarchical() {
        return true;
    }

    @Override
    public Choices getTopChoices(String authorityName, int start, int limit, String locale) {
        this.init();
        String xpathExpression = rootTemplate;
        return this.getChoicesByXpath(xpathExpression, start, limit);
    }

    @Override
    public Choices getChoicesByParent(String authorityName, String parentId, int start, int limit, String locale) {
        this.init();
        String xpathExpression = String.format(idTemplate, parentId);
        return this.getChoicesByXpath(xpathExpression, start, limit);
    }

    @Override
    public Choice getParentChoice(String authorityName, String childId, String locale) {
        this.init();
        try {
            String xpathExpression = String.format(idParentTemplate, childId);
            Choice choice = this.createChoiceFromNode(this.getNodeFromXPath(xpathExpression));
            return choice;
        }
        catch (XPathExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Integer getPreloadLevel() {
        return this.preloadLevel;
    }

    private boolean isRootElement(Node node) {
        return node != null && node.getOwnerDocument().getDocumentElement().equals(node);
    }

    private Node getNode(String key) throws XPathExpressionException {
        this.init();
        String xpathExpression = String.format(idTemplate, key);
        Node node = this.getNodeFromXPath(xpathExpression);
        return node;
    }

    private Node getNodeFromXPath(String xpathExpression) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.evaluate(xpathExpression, this.vocabulary, XPathConstants.NODE);
        return node;
    }

    private List<Choice> getChoicesFromNodeList(NodeList results, int start, int limit) {
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (int i = 0; i < results.getLength(); ++i) {
            if (i < start) continue;
            if (choices.size() == limit) break;
            Node node = results.item(i);
            Choice choice = new Choice(this.getAuthority(node), this.getLabel(node), this.getValue(node), this.isSelectable(node));
            choice.extras = this.addOtherInformation(this.getParent(node), this.getNote(node), this.getChildren(node), this.getAuthority(node));
            choices.add(choice);
        }
        return choices;
    }

    private Map<String, String> addOtherInformation(String parentCurr, String noteCurr, List<String> childrenCurr, String authorityCurr) {
        HashMap<String, String> extras = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)parentCurr)) {
            extras.put("parent", parentCurr);
        }
        if (StringUtils.isNotBlank((CharSequence)noteCurr)) {
            extras.put("note", noteCurr);
        }
        if (childrenCurr.size() > 0) {
            extras.put("hasChildren", "true");
        } else {
            extras.put("hasChildren", "false");
        }
        extras.put("id", authorityCurr);
        return extras;
    }

    private String getNodeLabel(String key, boolean useHierarchy) {
        try {
            Node node = this.getNode(key);
            if (Objects.isNull(node)) {
                return null;
            }
            if (useHierarchy) {
                return this.buildString(node);
            }
            return node.getAttributes().getNamedItem("label").getNodeValue();
        }
        catch (XPathExpressionException e) {
            return "";
        }
    }

    private String getLabel(Node node) {
        String hierarchy = this.buildString(node);
        if (this.suggestHierarchy.booleanValue()) {
            return hierarchy;
        }
        return node.getAttributes().getNamedItem("label").getNodeValue();
    }

    private String getValue(Node node) {
        String hierarchy = this.buildString(node);
        if (this.storeHierarchy.booleanValue()) {
            return hierarchy;
        }
        return node.getAttributes().getNamedItem("label").getNodeValue();
    }

    private String getNote(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int ci = 0; ci < childNodes.getLength(); ++ci) {
            String nodeValue;
            Node firstChild = childNodes.item(ci);
            if (firstChild == null || !"hasNote".equals(firstChild.getNodeName()) || !StringUtils.isNotBlank((CharSequence)(nodeValue = firstChild.getTextContent()))) continue;
            return nodeValue;
        }
        return null;
    }

    private List<String> getChildren(Node node) {
        ArrayList<String> children = new ArrayList<String>();
        NodeList childNodes = node.getChildNodes();
        for (int ci = 0; ci < childNodes.getLength(); ++ci) {
            Node firstChild = childNodes.item(ci);
            if (firstChild == null || !"isComposedBy".equals(firstChild.getNodeName())) continue;
            for (int cii = 0; cii < firstChild.getChildNodes().getLength(); ++cii) {
                Node childIdAttr;
                Node childN = firstChild.getChildNodes().item(cii);
                if (childN == null || !"node".equals(childN.getNodeName()) || null == (childIdAttr = childN.getAttributes().getNamedItem("id"))) continue;
                children.add(childIdAttr.getNodeValue());
            }
            break;
        }
        return children;
    }

    private boolean isSelectable(Node node) {
        Node selectableAttr = node.getAttributes().getNamedItem("selectable");
        if (null != selectableAttr) {
            return Boolean.valueOf(selectableAttr.getNodeValue());
        }
        return true;
    }

    private String getParent(Node node) {
        Node parentN = node.getParentNode();
        if (parentN != null && (parentN = parentN.getParentNode()) != null && !this.isRootElement(parentN)) {
            return this.buildString(parentN);
        }
        return null;
    }

    private String getAuthority(Node node) {
        Node idAttr = node.getAttributes().getNamedItem("id");
        if (null != idAttr) {
            return idAttr.getNodeValue();
        }
        return null;
    }

    private Choices getChoicesByXpath(String xpathExpression, int start, int limit) {
        ArrayList<Choice> choices = new ArrayList<Choice>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Node parentNode = (Node)xpath.evaluate(xpathExpression, this.vocabulary, XPathConstants.NODE);
            int count = 0;
            if (parentNode != null) {
                NodeList childNodes = (NodeList)xpath.evaluate(".//isComposedBy", parentNode, XPathConstants.NODE);
                if (null != childNodes) {
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node childNode = childNodes.item(i);
                        if (childNode == null || !"node".equals(childNode.getNodeName())) continue;
                        if (count < start || choices.size() >= limit) {
                            ++count;
                            continue;
                        }
                        ++count;
                        choices.add(this.createChoiceFromNode(childNode));
                    }
                }
                return new Choices(choices.toArray(new Choice[choices.size()]), start, count, 400, false);
            }
        }
        catch (XPathExpressionException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new Choices(true);
        }
        return new Choices(false);
    }

    private Choice createChoiceFromNode(Node node) {
        if (node != null && !this.isRootElement(node)) {
            Choice choice = new Choice(this.getAuthority(node), this.getLabel(node), this.getValue(node), this.isSelectable(node));
            choice.extras = this.addOtherInformation(this.getParent(node), this.getNote(node), this.getChildren(node), this.getAuthority(node));
            return choice;
        }
        return null;
    }
}

