/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipMetadataService;
import org.dspace.content.RelationshipMetadataValue;
import org.dspace.content.RelationshipType;
import org.dspace.content.dao.RelationshipDAO;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.virtual.VirtualMetadataPopulator;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class RelationshipServiceImpl
implements RelationshipService {
    private static final Logger log = LogManager.getLogger();
    @Autowired(required=true)
    protected RelationshipDAO relationshipDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected RelationshipTypeService relationshipTypeService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private RelationshipMetadataService relationshipMetadataService;
    @Autowired
    private VirtualMetadataPopulator virtualMetadataPopulator;

    @Override
    public Relationship create(Context context) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can modify relationship");
        }
        return this.relationshipDAO.create(context, new Relationship());
    }

    @Override
    public Relationship create(Context c, Item leftItem, Item rightItem, RelationshipType relationshipType, int leftPlace, int rightPlace) throws AuthorizeException, SQLException {
        return this.create(c, leftItem, rightItem, relationshipType, leftPlace, rightPlace, null, null);
    }

    @Override
    public Relationship create(Context c, Item leftItem, Item rightItem, RelationshipType relationshipType, int leftPlace, int rightPlace, String leftwardValue, String rightwardValue) throws AuthorizeException, SQLException {
        Relationship relationship = new Relationship();
        relationship.setLeftItem(leftItem);
        relationship.setRightItem(rightItem);
        relationship.setRelationshipType(relationshipType);
        relationship.setLeftPlace(leftPlace);
        relationship.setRightPlace(rightPlace);
        relationship.setLeftwardValue(leftwardValue);
        relationship.setRightwardValue(rightwardValue);
        return this.create(c, relationship);
    }

    @Override
    public Relationship create(Context context, Relationship relationship) throws SQLException, AuthorizeException {
        if (this.isRelationshipValidToCreate(context, relationship)) {
            if (this.authorizeService.authorizeActionBoolean(context, relationship.getLeftItem(), 1) || this.authorizeService.authorizeActionBoolean(context, relationship.getRightItem(), 1)) {
                Relationship relationshipToReturn = this.relationshipDAO.create(context, relationship);
                this.updatePlaceInRelationship(context, relationshipToReturn);
                this.update(context, relationshipToReturn);
                this.updateItemsInRelationship(context, relationship);
                return relationshipToReturn;
            }
            throw new AuthorizeException("You do not have write rights on this relationship's items");
        }
        throw new IllegalArgumentException("The relationship given was not valid");
    }

    @Override
    public void updatePlaceInRelationship(Context context, Relationship relationship) throws SQLException, AuthorizeException {
        int i;
        Item leftItem = relationship.getLeftItem();
        if (relationship.getLeftPlace() == -1) {
            relationship.setLeftPlace(Integer.MAX_VALUE);
        }
        Item rightItem = relationship.getRightItem();
        if (relationship.getRightPlace() == -1) {
            relationship.setRightPlace(Integer.MAX_VALUE);
        }
        List<Relationship> leftRelationships = this.findByItemAndRelationshipType(context, leftItem, relationship.getRelationshipType(), true);
        List<Relationship> rightRelationships = this.findByItemAndRelationshipType(context, rightItem, relationship.getRelationshipType(), false);
        if (leftRelationships.contains(relationship)) {
            leftRelationships.remove(relationship);
        }
        if (rightRelationships.contains(relationship)) {
            rightRelationships.remove(relationship);
        }
        context.turnOffAuthorisationSystem();
        if (!this.virtualMetadataPopulator.isUseForPlaceTrueForRelationshipType(relationship.getRelationshipType(), true)) {
            if (!leftRelationships.isEmpty()) {
                leftRelationships.sort(Comparator.comparingInt(Relationship::getLeftPlace));
                for (i = 0; i < leftRelationships.size(); ++i) {
                    leftRelationships.get(i).setLeftPlace(i);
                }
                relationship.setLeftPlace(leftRelationships.size());
            } else {
                relationship.setLeftPlace(0);
            }
        } else {
            this.updateItem(context, leftItem);
        }
        if (!this.virtualMetadataPopulator.isUseForPlaceTrueForRelationshipType(relationship.getRelationshipType(), false)) {
            if (!rightRelationships.isEmpty()) {
                rightRelationships.sort(Comparator.comparingInt(Relationship::getRightPlace));
                for (i = 0; i < rightRelationships.size(); ++i) {
                    rightRelationships.get(i).setRightPlace(i);
                }
                relationship.setRightPlace(rightRelationships.size());
            } else {
                relationship.setRightPlace(0);
            }
        } else {
            this.updateItem(context, rightItem);
        }
        context.restoreAuthSystemState();
    }

    @Override
    public void updateItem(Context context, Item relatedItem) throws SQLException, AuthorizeException {
        relatedItem.setMetadataModified();
        this.itemService.update(context, relatedItem);
    }

    @Override
    public int findNextLeftPlaceByLeftItem(Context context, Item item) throws SQLException {
        return this.relationshipDAO.findNextLeftPlaceByLeftItem(context, item);
    }

    @Override
    public int findNextRightPlaceByRightItem(Context context, Item item) throws SQLException {
        return this.relationshipDAO.findNextRightPlaceByRightItem(context, item);
    }

    private boolean isRelationshipValidToCreate(Context context, Relationship relationship) throws SQLException {
        RelationshipType relationshipType = relationship.getRelationshipType();
        if (!this.verifyEntityTypes(relationship.getLeftItem(), relationshipType.getLeftType())) {
            log.warn("The relationship has been deemed invalid since the leftItem and leftType do no match on entityType");
            this.logRelationshipTypeDetailsForError(relationshipType);
            return false;
        }
        if (!this.verifyEntityTypes(relationship.getRightItem(), relationshipType.getRightType())) {
            log.warn("The relationship has been deemed invalid since the rightItem and rightType do no match on entityType");
            this.logRelationshipTypeDetailsForError(relationshipType);
            return false;
        }
        if (!this.verifyMaxCardinality(context, relationship.getLeftItem(), relationshipType.getLeftMaxCardinality(), relationshipType, true)) {
            log.warn("The relationship has been deemed invalid since the left item has more relationships than the left max cardinality allows after we'd store this relationship");
            this.logRelationshipTypeDetailsForError(relationshipType);
            return false;
        }
        if (!this.verifyMaxCardinality(context, relationship.getRightItem(), relationshipType.getRightMaxCardinality(), relationshipType, false)) {
            log.warn("The relationship has been deemed invalid since the right item has more relationships than the right max cardinality allows after we'd store this relationship");
            this.logRelationshipTypeDetailsForError(relationshipType);
            return false;
        }
        return true;
    }

    private void logRelationshipTypeDetailsForError(RelationshipType relationshipType) {
        log.warn("The relationshipType's ID is: " + relationshipType.getID());
        log.warn("The relationshipType's leftward type is: " + relationshipType.getLeftwardType());
        log.warn("The relationshipType's rightward type is: " + relationshipType.getRightwardType());
        log.warn("The relationshipType's left entityType label is: " + relationshipType.getLeftType().getLabel());
        log.warn("The relationshipType's right entityType label is: " + relationshipType.getRightType().getLabel());
        log.warn("The relationshipType's left min cardinality is: " + relationshipType.getLeftMinCardinality());
        log.warn("The relationshipType's left max cardinality is: " + relationshipType.getLeftMaxCardinality());
        log.warn("The relationshipType's right min cardinality is: " + relationshipType.getRightMinCardinality());
        log.warn("The relationshipType's right max cardinality is: " + relationshipType.getRightMaxCardinality());
    }

    private boolean verifyMaxCardinality(Context context, Item itemToProcess, Integer maxCardinality, RelationshipType relationshipType, boolean isLeft) throws SQLException {
        if (maxCardinality == null) {
            return true;
        }
        List<Relationship> rightRelationships = this.findByItemAndRelationshipType(context, itemToProcess, relationshipType, isLeft);
        return maxCardinality == null || rightRelationships.size() < maxCardinality;
    }

    private boolean verifyEntityTypes(Item itemToProcess, EntityType entityTypeToProcess) {
        List<MetadataValue> list = this.itemService.getMetadata(itemToProcess, "dspace", "entity", "type", "*", false);
        if (list.isEmpty()) {
            return false;
        }
        String leftEntityType = list.get(0).getValue();
        return StringUtils.equals((CharSequence)leftEntityType, (CharSequence)entityTypeToProcess.getLabel());
    }

    @Override
    public Relationship find(Context context, int id) throws SQLException {
        Relationship relationship = (Relationship)this.relationshipDAO.findByID(context, Relationship.class, id);
        return relationship;
    }

    @Override
    public List<Relationship> findByItem(Context context, Item item) throws SQLException {
        return this.findByItem(context, item, -1, -1, false);
    }

    @Override
    public List<Relationship> findByItem(Context context, Item item, Integer limit, Integer offset, boolean excludeTilted) throws SQLException {
        List<Relationship> list = this.relationshipDAO.findByItem(context, item, limit, offset, excludeTilted);
        list.sort((o1, o2) -> {
            int relationshipType = o1.getRelationshipType().getLeftwardType().compareTo(o2.getRelationshipType().getLeftwardType());
            if (relationshipType != 0) {
                return relationshipType;
            }
            if (o1.getLeftItem() == item) {
                return o1.getLeftPlace() - o2.getLeftPlace();
            }
            return o1.getRightPlace() - o2.getRightPlace();
        });
        return list;
    }

    @Override
    public List<Relationship> findAll(Context context) throws SQLException {
        return this.findAll(context, -1, -1);
    }

    @Override
    public List<Relationship> findAll(Context context, Integer limit, Integer offset) throws SQLException {
        return this.relationshipDAO.findAll(context, Relationship.class, limit, offset);
    }

    @Override
    public void update(Context context, Relationship relationship) throws SQLException, AuthorizeException {
        this.update(context, Collections.singletonList(relationship));
    }

    @Override
    public void update(Context context, List<Relationship> relationships) throws SQLException, AuthorizeException {
        if (CollectionUtils.isNotEmpty(relationships)) {
            for (Relationship relationship : relationships) {
                if (this.authorizeService.authorizeActionBoolean(context, relationship.getLeftItem(), 1) || this.authorizeService.authorizeActionBoolean(context, relationship.getRightItem(), 1)) {
                    if (!this.isRelationshipValidToCreate(context, relationship)) continue;
                    this.relationshipDAO.save(context, relationship);
                    continue;
                }
                throw new AuthorizeException("You do not have write rights on this relationship's items");
            }
        }
    }

    @Override
    public void delete(Context context, Relationship relationship) throws SQLException, AuthorizeException {
        this.delete(context, relationship, relationship.getRelationshipType().isCopyToLeft(), relationship.getRelationshipType().isCopyToRight());
    }

    @Override
    public void delete(Context context, Relationship relationship, boolean copyToLeftItem, boolean copyToRightItem) throws SQLException, AuthorizeException {
        log.info(org.dspace.core.LogManager.getHeader(context, "delete_relationship", "relationship_id=" + relationship.getID() + "&copyMetadataValuesToLeftItem=" + copyToLeftItem + "&copyMetadataValuesToRightItem=" + copyToRightItem));
        if (!this.isRelationshipValidToDelete(context, relationship) || !this.copyToItemPermissionCheck(context, relationship, copyToLeftItem, copyToRightItem)) {
            throw new IllegalArgumentException("The relationship given was not valid");
        }
        this.deleteRelationshipAndCopyToItem(context, relationship, copyToLeftItem, copyToRightItem);
    }

    @Override
    public void forceDelete(Context context, Relationship relationship, boolean copyToLeftItem, boolean copyToRightItem) throws SQLException, AuthorizeException {
        log.info(org.dspace.core.LogManager.getHeader(context, "delete_relationship", "relationship_id=" + relationship.getID() + "&copyMetadataValuesToLeftItem=" + copyToLeftItem + "&copyMetadataValuesToRightItem=" + copyToRightItem));
        if (!this.copyToItemPermissionCheck(context, relationship, copyToLeftItem, copyToRightItem)) {
            throw new IllegalArgumentException("The relationship given was not valid");
        }
        this.deleteRelationshipAndCopyToItem(context, relationship, copyToLeftItem, copyToRightItem);
    }

    private void deleteRelationshipAndCopyToItem(Context context, Relationship relationship, boolean copyToLeftItem, boolean copyToRightItem) throws SQLException, AuthorizeException {
        this.copyMetadataValues(context, relationship, copyToLeftItem, copyToRightItem);
        if (!this.authorizeService.authorizeActionBoolean(context, relationship.getLeftItem(), 1) && !this.authorizeService.authorizeActionBoolean(context, relationship.getRightItem(), 1)) {
            throw new AuthorizeException("You do not have write rights on this relationship's items");
        }
        this.relationshipDAO.delete(context, relationship);
        this.updatePlaceInRelationship(context, relationship);
        this.updateItemsInRelationship(context, relationship);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItemsInRelationship(Context context, Relationship relationship) throws SQLException {
        context.turnOffAuthorisationSystem();
        try {
            int max = this.configurationService.getIntProperty("relationship.update.relateditems.max", 20);
            int maxDepth = this.configurationService.getIntProperty("relationship.update.relateditems.maxdepth", 5);
            LinkedList<Item> itemsToUpdate = new LinkedList<Item>();
            itemsToUpdate.add(relationship.getLeftItem());
            itemsToUpdate.add(relationship.getRightItem());
            if (this.containsVirtualMetadata(relationship.getRelationshipType().getLeftwardType())) {
                this.findModifiedDiscoveryItemsForCurrentItem(context, relationship.getLeftItem(), itemsToUpdate, max, 0, maxDepth);
            }
            if (this.containsVirtualMetadata(relationship.getRelationshipType().getRightwardType())) {
                this.findModifiedDiscoveryItemsForCurrentItem(context, relationship.getRightItem(), itemsToUpdate, max, 0, maxDepth);
            }
            for (Item item : itemsToUpdate) {
                this.updateItem(context, item);
            }
        }
        catch (AuthorizeException e) {
            log.error("Authorization Exception while authorization has been disabled", (Throwable)e);
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    private void findModifiedDiscoveryItemsForCurrentItem(Context context, Item item, List<Item> itemsToUpdate, int max, int currentDepth, int maxDepth) throws SQLException {
        if (itemsToUpdate.size() >= max) {
            log.debug("skipping findModifiedDiscoveryItemsForCurrentItem for item " + item.getID() + " due to " + itemsToUpdate.size() + " items to be updated");
            return;
        }
        if (currentDepth == maxDepth) {
            log.debug("skipping findModifiedDiscoveryItemsForCurrentItem for item " + item.getID() + " due to " + currentDepth + " depth");
            return;
        }
        String entityTypeStringFromMetadata = this.relationshipMetadataService.getEntityTypeStringFromMetadata(item);
        EntityType actualEntityType = this.entityTypeService.findByEntityType(context, entityTypeStringFromMetadata);
        List<RelationshipType> relationshipTypes = this.relationshipTypeService.findByEntityType(context, actualEntityType);
        for (RelationshipType relationshipType : relationshipTypes) {
            boolean isLeft = relationshipType.getLeftType().equals(actualEntityType);
            String typeToSearchInVirtualMetadata = isLeft ? relationshipType.getRightwardType() : relationshipType.getLeftwardType();
            if (this.containsVirtualMetadata(typeToSearchInVirtualMetadata)) {
                List<Relationship> list = this.findByItemAndRelationshipType(context, item, relationshipType, isLeft);
                for (Relationship foundRelationship : list) {
                    Item nextItem = isLeft ? foundRelationship.getRightItem() : foundRelationship.getLeftItem();
                    if (itemsToUpdate.contains(nextItem)) continue;
                    itemsToUpdate.add(nextItem);
                    this.findModifiedDiscoveryItemsForCurrentItem(context, nextItem, itemsToUpdate, max, currentDepth + 1, maxDepth);
                }
                continue;
            }
            log.debug("skipping " + relationshipType.getID() + " in findModifiedDiscoveryItemsForCurrentItem for item " + item.getID() + " because no relevant virtual metadata was found");
        }
    }

    private boolean containsVirtualMetadata(String typeToSearchInVirtualMetadata) {
        return this.virtualMetadataPopulator.getMap().containsKey(typeToSearchInVirtualMetadata) && this.virtualMetadataPopulator.getMap().get(typeToSearchInVirtualMetadata).size() > 0;
    }

    private void copyMetadataValues(Context context, Relationship relationship, boolean copyToLeftItem, boolean copyToRightItem) throws SQLException, AuthorizeException {
        List<RelationshipMetadataValue> relationshipMetadataValues;
        String entityTypeString;
        if (copyToLeftItem) {
            entityTypeString = this.relationshipMetadataService.getEntityTypeStringFromMetadata(relationship.getLeftItem());
            relationshipMetadataValues = this.relationshipMetadataService.findRelationshipMetadataValueForItemRelationship(context, relationship.getLeftItem(), entityTypeString, relationship, true);
            for (RelationshipMetadataValue relationshipMetadataValue : relationshipMetadataValues) {
                this.itemService.addAndShiftRightMetadata(context, relationship.getLeftItem(), relationshipMetadataValue.getMetadataField().getMetadataSchema().getName(), relationshipMetadataValue.getMetadataField().getElement(), relationshipMetadataValue.getMetadataField().getQualifier(), relationshipMetadataValue.getLanguage(), relationshipMetadataValue.getValue(), null, -1, relationshipMetadataValue.getPlace());
            }
            this.itemService.update(context, relationship.getLeftItem());
        }
        if (copyToRightItem) {
            entityTypeString = this.relationshipMetadataService.getEntityTypeStringFromMetadata(relationship.getRightItem());
            relationshipMetadataValues = this.relationshipMetadataService.findRelationshipMetadataValueForItemRelationship(context, relationship.getRightItem(), entityTypeString, relationship, true);
            for (RelationshipMetadataValue relationshipMetadataValue : relationshipMetadataValues) {
                this.itemService.addAndShiftRightMetadata(context, relationship.getRightItem(), relationshipMetadataValue.getMetadataField().getMetadataSchema().getName(), relationshipMetadataValue.getMetadataField().getElement(), relationshipMetadataValue.getMetadataField().getQualifier(), relationshipMetadataValue.getLanguage(), relationshipMetadataValue.getValue(), null, -1, relationshipMetadataValue.getPlace());
            }
            this.itemService.update(context, relationship.getRightItem());
        }
    }

    private boolean copyToItemPermissionCheck(Context context, Relationship relationship, boolean copyToLeftItem, boolean copyToRightItem) throws SQLException {
        boolean isPermissionCorrect = true;
        if (copyToLeftItem && !this.authorizeService.authorizeActionBoolean(context, relationship.getLeftItem(), 1)) {
            isPermissionCorrect = false;
        }
        if (copyToRightItem && !this.authorizeService.authorizeActionBoolean(context, relationship.getRightItem(), 1)) {
            isPermissionCorrect = false;
        }
        return isPermissionCorrect;
    }

    private boolean isRelationshipValidToDelete(Context context, Relationship relationship) throws SQLException {
        if (relationship == null) {
            log.warn("The relationship has been deemed invalid since the relation was null");
            return false;
        }
        if (relationship.getID() == null) {
            log.warn("The relationship has been deemed invalid since the ID off the given relationship was null");
            return false;
        }
        if (this.find(context, relationship.getID()) == null) {
            log.warn("The relationship has been deemed invalid since the relationship is not present in the DB with the current ID");
            this.logRelationshipTypeDetailsForError(relationship.getRelationshipType());
            return false;
        }
        if (!this.checkMinCardinality(context, relationship.getLeftItem(), relationship, relationship.getRelationshipType().getLeftMinCardinality(), true)) {
            log.warn("The relationship has been deemed invalid since the leftMinCardinality constraint would be violated upon deletion");
            this.logRelationshipTypeDetailsForError(relationship.getRelationshipType());
            return false;
        }
        if (!this.checkMinCardinality(context, relationship.getRightItem(), relationship, relationship.getRelationshipType().getRightMinCardinality(), false)) {
            log.warn("The relationship has been deemed invalid since the rightMinCardinality constraint would be violated upon deletion");
            this.logRelationshipTypeDetailsForError(relationship.getRelationshipType());
            return false;
        }
        return true;
    }

    private boolean checkMinCardinality(Context context, Item item, Relationship relationship, Integer minCardinality, boolean isLeft) throws SQLException {
        List<Relationship> list = this.findByItemAndRelationshipType(context, item, relationship.getRelationshipType(), isLeft, -1, -1);
        return minCardinality == null || list.size() > minCardinality;
    }

    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft) throws SQLException {
        return this.findByItemAndRelationshipType(context, item, relationshipType, isLeft, -1, -1);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType) throws SQLException {
        return this.relationshipDAO.findByItemAndRelationshipType(context, item, relationshipType, -1, -1);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, int limit, int offset) throws SQLException {
        return this.relationshipDAO.findByItemAndRelationshipType(context, item, relationshipType, limit, offset);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft, int limit, int offset) throws SQLException {
        return this.relationshipDAO.findByItemAndRelationshipType(context, item, relationshipType, isLeft, limit, offset);
    }

    @Override
    public List<Relationship> findByRelationshipType(Context context, RelationshipType relationshipType) throws SQLException {
        return this.findByRelationshipType(context, relationshipType, -1, -1);
    }

    @Override
    public List<Relationship> findByRelationshipType(Context context, RelationshipType relationshipType, Integer limit, Integer offset) throws SQLException {
        return this.relationshipDAO.findByRelationshipType(context, relationshipType, limit, offset);
    }

    @Override
    public List<Relationship> findByTypeName(Context context, String typeName) throws SQLException {
        return this.findByTypeName(context, typeName, -1, -1);
    }

    @Override
    public List<Relationship> findByTypeName(Context context, String typeName, Integer limit, Integer offset) throws SQLException {
        return this.relationshipDAO.findByTypeName(context, typeName, limit, offset);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.relationshipDAO.countRows(context);
    }

    @Override
    public int countByItem(Context context, Item item) throws SQLException {
        return this.relationshipDAO.countByItem(context, item);
    }

    @Override
    public int countByRelationshipType(Context context, RelationshipType relationshipType) throws SQLException {
        return this.relationshipDAO.countByRelationshipType(context, relationshipType);
    }

    @Override
    public int countByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft) throws SQLException {
        return this.relationshipDAO.countByItemAndRelationshipType(context, item, relationshipType, isLeft);
    }

    @Override
    public int countByTypeName(Context context, String typeName) throws SQLException {
        return this.relationshipDAO.countByTypeName(context, typeName);
    }
}

