/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.dao.MetadataValueDAO;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.springframework.beans.factory.annotation.Autowired;

public class MetadataValueServiceImpl
implements MetadataValueService {
    private static final Logger log = org.apache.logging.log4j.LogManager.getLogger(MetadataValueServiceImpl.class);
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected MetadataValueDAO metadataValueDAO;
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;

    protected MetadataValueServiceImpl() {
    }

    @Override
    public MetadataValue create(Context context, DSpaceObject dso, MetadataField metadataField) throws SQLException {
        MetadataValue metadataValue = new MetadataValue();
        metadataValue.setMetadataField(metadataField);
        metadataValue.setDSpaceObject(dso);
        dso.addMetadata(metadataValue);
        metadataValue = this.metadataValueDAO.create(context, metadataValue);
        return metadataValue;
    }

    @Override
    public MetadataValue find(Context context, int valueId) throws IOException, SQLException {
        return (MetadataValue)this.metadataValueDAO.findByID(context, MetadataValue.class, valueId);
    }

    @Override
    public List<MetadataValue> findByField(Context context, MetadataField metadataField) throws IOException, SQLException {
        return this.metadataValueDAO.findByField(context, metadataField);
    }

    @Override
    public Iterator<MetadataValue> findByFieldAndValue(Context context, MetadataField metadataField, String value) throws SQLException {
        return this.metadataValueDAO.findItemValuesByFieldAndValue(context, metadataField, value);
    }

    @Override
    public void update(Context context, MetadataValue metadataValue) throws SQLException {
        this.metadataValueDAO.save(context, metadataValue);
        log.info(LogManager.getHeader(context, "update_metadatavalue", "metadata_value_id=" + metadataValue.getID()));
    }

    @Override
    public void update(Context context, MetadataValue metadataValue, boolean updateLastModified) throws SQLException, AuthorizeException {
        if (updateLastModified) {
            this.authorizeService.authorizeAction(context, metadataValue.getDSpaceObject(), 1);
            DSpaceObjectService<DSpaceObject> dSpaceObjectService = this.contentServiceFactory.getDSpaceObjectService(metadataValue.getDSpaceObject());
            DSpaceObject dso = dSpaceObjectService.find(context, metadataValue.getDSpaceObject().getID());
            dSpaceObjectService.updateLastModified(context, dso);
        }
        this.update(context, metadataValue);
    }

    @Override
    public void delete(Context context, MetadataValue metadataValue) throws SQLException {
        log.info(LogManager.getHeader(context, "delete_metadata_value", " metadata_value_id=" + metadataValue.getID()));
        this.metadataValueDAO.delete(context, metadataValue);
    }

    @Override
    public Iterator<MetadataValue> findByValueLike(Context context, String value) throws SQLException {
        return this.metadataValueDAO.findByValueLike(context, value);
    }

    @Override
    public void deleteByMetadataField(Context context, MetadataField metadataField) throws SQLException {
        this.metadataValueDAO.deleteByMetadataField(context, metadataField);
    }

    @Override
    public MetadataValue getMinimum(Context context, int metadataFieldId) throws SQLException {
        return this.metadataValueDAO.getMinimum(context, metadataFieldId);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.metadataValueDAO.countRows(context);
    }
}

