/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.lang.reflect.InvocationTargetException;
import org.dspace.browse.ItemCountDAO;
import org.dspace.browse.ItemCountDAOSolr;
import org.dspace.browse.ItemCountException;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class ItemCountDAOFactory {
    private ItemCountDAOFactory() {
    }

    public static ItemCountDAO getInstance(Context context) throws ItemCountException {
        ItemCountDAO dao = null;
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        String className = configurationService.getProperty("ItemCountDAO.class");
        if (className == null) {
            dao = new ItemCountDAOSolr();
        } else {
            try {
                dao = (ItemCountDAO)Class.forName(className.trim()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new ItemCountException("The configuration for ItemCountDAO is invalid: " + className, e);
            }
        }
        dao.setContext(context);
        return dao;
    }
}

