/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.lang.reflect.InvocationTargetException;
import org.dspace.browse.BrowseDAO;
import org.dspace.browse.BrowseException;
import org.dspace.browse.SolrBrowseDAO;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class BrowseDAOFactory {
    private BrowseDAOFactory() {
    }

    public static BrowseDAO getInstance(Context context) throws BrowseException {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        String className = configurationService.getProperty("browseDAO.class");
        if (className == null) {
            return new SolrBrowseDAO(context);
        }
        try {
            return (BrowseDAO)Class.forName(configurationService.getProperty("browseDAO.class")).getConstructor(Context.class).newInstance(context);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new BrowseException("The configuration for browseDAO is invalid: " + className, e);
        }
    }
}

