/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.xpath.XPathAPI;
import org.dspace.app.itemupdate.ContentsEntry;
import org.dspace.app.itemupdate.DtoMetadata;
import org.dspace.app.itemupdate.ItemUpdate;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MetadataUtilities {
    protected static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    private MetadataUtilities() {
    }

    public static boolean deleteMetadataByValue(Context context, Item item, DtoMetadata dtom, boolean isLanguageStrict) throws SQLException {
        List<MetadataValue> ar = null;
        ar = isLanguageStrict ? itemService.getMetadata(item, dtom.schema, dtom.element, dtom.qualifier, dtom.language) : itemService.getMetadata(item, dtom.schema, dtom.element, dtom.qualifier, "*");
        boolean found = false;
        ArrayList<String> vals = new ArrayList<String>();
        for (MetadataValue dcv : ar) {
            if (dcv.getValue().equals(dtom.value)) {
                found = true;
                continue;
            }
            vals.add(dcv.getValue());
        }
        if (found) {
            if (isLanguageStrict) {
                itemService.clearMetadata(context, item, dtom.schema, dtom.element, dtom.qualifier, dtom.language);
            } else {
                itemService.clearMetadata(context, item, dtom.schema, dtom.element, dtom.qualifier, "*");
            }
            itemService.addMetadata(context, item, dtom.schema, dtom.element, dtom.qualifier, dtom.language, vals);
        }
        return found;
    }

    public static void appendMetadata(Context context, Item item, DtoMetadata dtom, boolean isLanguageStrict, String textToAppend) throws IllegalArgumentException, SQLException {
        List<MetadataValue> ar = null;
        ar = isLanguageStrict ? itemService.getMetadata(item, dtom.schema, dtom.element, dtom.qualifier, dtom.language) : itemService.getMetadata(item, dtom.schema, dtom.element, dtom.qualifier, "*");
        if (ar.size() == 0) {
            throw new IllegalArgumentException("Metadata to append to not found");
        }
        int idx = 0;
        if (ar.size() > 1) {
            // empty if block
        }
        ArrayList<String> vals = new ArrayList<String>();
        for (int i = 0; i < ar.size(); ++i) {
            if (i == idx) {
                vals.add(ar.get(i).getValue() + textToAppend);
                continue;
            }
            vals.add(ar.get(i).getValue());
        }
        if (isLanguageStrict) {
            itemService.clearMetadata(context, item, dtom.schema, dtom.element, dtom.qualifier, dtom.language);
        } else {
            itemService.clearMetadata(context, item, dtom.schema, dtom.element, dtom.qualifier, "*");
        }
        itemService.addMetadata(context, item, dtom.schema, dtom.element, dtom.qualifier, dtom.language, vals);
    }

    public static List<DtoMetadata> loadDublinCore(DocumentBuilder docBuilder, InputStream is) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException, AuthorizeException {
        Document document = docBuilder.parse(is);
        ArrayList<DtoMetadata> dtomList = new ArrayList<DtoMetadata>();
        String schema = null;
        NodeList metadata = XPathAPI.selectNodeList((Node)document, (String)"/dublin_core");
        Node schemaAttr = metadata.item(0).getAttributes().getNamedItem("schema");
        schema = schemaAttr == null ? MetadataSchemaEnum.DC.getName() : schemaAttr.getNodeValue();
        NodeList dcNodes = XPathAPI.selectNodeList((Node)document, (String)"/dublin_core/dcvalue");
        for (int i = 0; i < dcNodes.getLength(); ++i) {
            String language;
            String qualifier;
            String element;
            Node n = dcNodes.item(i);
            String value = MetadataUtilities.getStringValue(n).trim();
            if (value == null) {
                value = "";
            }
            if ((element = MetadataUtilities.getAttributeValue(n, "element")) != null) {
                element = element.trim();
            }
            if ((qualifier = MetadataUtilities.getAttributeValue(n, "qualifier")) != null) {
                qualifier = qualifier.trim();
            }
            if ((language = MetadataUtilities.getAttributeValue(n, "language")) != null) {
                language = language.trim();
            }
            if ("none".equals(qualifier) || "".equals(qualifier)) {
                qualifier = null;
            }
            if (language == null) {
                language = "en";
            } else if ("".equals(language)) {
                language = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("default.language");
            }
            DtoMetadata dtom = DtoMetadata.create(schema, element, qualifier, language, value);
            ItemUpdate.pr(dtom.toString());
            dtomList.add(dtom);
        }
        return dtomList;
    }

    public static Document writeDublinCore(DocumentBuilder docBuilder, List<DtoMetadata> dtomList) throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("dublin_core");
        doc.appendChild(root);
        for (DtoMetadata dtom : dtomList) {
            Element mel = doc.createElement("dcvalue");
            mel.setAttribute("element", dtom.element);
            if (dtom.qualifier == null) {
                mel.setAttribute("qualifier", "none");
            } else {
                mel.setAttribute("qualifier", dtom.qualifier);
            }
            if (StringUtils.isEmpty((CharSequence)dtom.language)) {
                mel.setAttribute("language", "en");
            } else {
                mel.setAttribute("language", dtom.language);
            }
            mel.setTextContent(dtom.value);
            root.appendChild(mel);
        }
        return doc;
    }

    public static void writeDocument(Document doc, Transformer transformer, OutputStream out) throws IOException, TransformerException {
        DOMSource src = new DOMSource(doc);
        StreamResult dest = new StreamResult(out);
        transformer.transform(src, dest);
    }

    private static String getAttributeValue(Node n, String name) {
        NamedNodeMap nm = n.getAttributes();
        for (int i = 0; i < nm.getLength(); ++i) {
            Node node = nm.item(i);
            if (!name.equals(node.getNodeName())) continue;
            return node.getNodeValue();
        }
        return "";
    }

    private static String getStringValue(Node node) {
        Node first;
        String value = node.getNodeValue();
        if (node.hasChildNodes() && (first = node.getFirstChild()).getNodeType() == 3) {
            return first.getNodeValue();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ContentsEntry> readContentsFile(File f) throws FileNotFoundException, IOException, ParseException {
        ArrayList<ContentsEntry> list = new ArrayList<ContentsEntry>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = in.readLine()) != null) {
                if ("".equals(line = line.trim())) continue;
                ItemUpdate.pr("Contents entry: " + line);
                list.add(ContentsEntry.parse(line));
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readDeleteContentsFile(File f) throws FileNotFoundException, IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = in.readLine()) != null) {
                if ("".equals(line = line.trim())) continue;
                list.add(line);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return list;
    }

    public static String getDCValueString(MetadataValue dcv) {
        MetadataField metadataField = dcv.getMetadataField();
        MetadataSchema metadataSchema = metadataField.getMetadataSchema();
        return "schema: " + metadataSchema.getName() + "; element: " + metadataField.getElement() + "; qualifier: " + metadataField.getQualifier() + "; language: " + dcv.getLanguage() + "; value: " + dcv.getValue();
    }

    public static String getCompoundForm(String schema, String element, String qualifier) {
        StringBuilder sb = new StringBuilder();
        sb.append(schema).append(".").append(element);
        if (qualifier != null) {
            sb.append(".").append(qualifier);
        }
        return sb.toString();
    }

    public static String[] parseCompoundForm(String compoundForm) throws ParseException {
        String[] ar = compoundForm.split("\\s*\\.\\s*");
        if ("".equals(ar[0])) {
            throw new ParseException("schema is empty string: " + compoundForm, 0);
        }
        if (ar.length < 2 || ar.length > 3 || "".equals(ar[1])) {
            throw new ParseException("element is malformed or empty string: " + compoundForm, 0);
        }
        return ar;
    }
}

